/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.portal;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.entity.ChangeEntityWorldEvent;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.portal.Portal;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.entity.EntityAccessor;
import org.spongepowered.common.accessor.entity.player.ServerPlayerEntityAccessor;
import org.spongepowered.common.bridge.entity.PlatformEntityBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.portal.PortalHelper;
import org.spongepowered.common.world.portal.VanillaPortalType;

public final class NetherPortalType
extends VanillaPortalType {
    public NetherPortalType(ResourceKey key) {
        super(key);
    }

    @Override
    public void generatePortal(ServerLocation location) {
        Objects.requireNonNull(location);
        PortalHelper.generateNetherPortal((net.minecraft.world.server.ServerWorld)location.getWorld(), location.getBlockX(), location.getBlockY(), location.getBlockZ(), true);
    }

    @Override
    public Optional<Portal> findPortal(ServerLocation location) {
        Objects.requireNonNull(location);
        return Optional.empty();
    }

    @Override
    public boolean teleport(org.spongepowered.api.entity.Entity entity, ServerLocation destination, boolean generateDestinationPortal) {
        Objects.requireNonNull(entity);
        Objects.requireNonNull(destination);
        Entity mEntity = (Entity)entity;
        if (mEntity.isPassenger() || mEntity.isBeingRidden() || !mEntity.isNonBoss()) {
            return false;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            boolean worldChange;
            frame.pushCause(SpongeCommon.getActivePlugin());
            frame.pushCause(this);
            frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.PORTAL);
            ServerLocation previousLocation = entity.getServerLocation();
            ServerLocation actualDestination = destination;
            boolean bl = worldChange = !previousLocation.getWorldKey().equals(actualDestination.getWorldKey());
            if (worldChange) {
                ChangeEntityWorldEvent.Pre event = PlatformHooks.getInstance().getEventHooks().callChangeEntityWorldEventPre((Entity)entity, (net.minecraft.world.server.ServerWorld)destination.getWorld());
                if (event == null || event.isCancelled() || ((WorldBridge)((Object)event.getDestinationWorld())).bridge$isFake()) {
                    boolean bl2 = false;
                    return bl2;
                }
                actualDestination = ServerLocation.of(event.getDestinationWorld(), entity.getPosition());
            }
            Function<Boolean, Entity> portalLogic = entity instanceof ServerPlayerEntity ? PortalHelper.createVanillaPlayerPortalLogic((ServerPlayerEntity)entity, VecHelper.toVec3d(actualDestination.getPosition()), (net.minecraft.world.server.ServerWorld)previousLocation.getWorld(), (net.minecraft.world.server.ServerWorld)actualDestination.getWorld(), this) : PortalHelper.createVanillaEntityPortalLogic((Entity)entity, VecHelper.toVec3d(actualDestination.getPosition()), (net.minecraft.world.server.ServerWorld)previousLocation.getWorld(), (net.minecraft.world.server.ServerWorld)actualDestination.getWorld(), this);
            ((Entity)entity).setPortal(VecHelper.toBlockPos(previousLocation.getPosition()));
            if (entity instanceof ServerPlayerEntity) {
                ((ServerPlayerEntityAccessor)((Object)entity)).accessor$setInvulnerableDimensionChange(true);
            }
            Entity result = portalLogic.apply(generateDestinationPortal);
            ((EntityAccessor)((Object)entity)).accessor$setInPortal(false);
            if (result == null) {
                boolean bl3 = false;
                return bl3;
            }
            ServerLocation currentLocation = ((org.spongepowered.api.entity.Entity)mEntity).getServerLocation();
            if (previousLocation.getWorld() == actualDestination.getWorld() && previousLocation.getBlockPosition().equals((Object)currentLocation.getBlockPosition())) {
                boolean bl4 = false;
                return bl4;
            }
            actualDestination = ServerLocation.of((ServerWorld)actualDestination.getWorld(), currentLocation.getPosition());
            if (!worldChange) {
                ((EntityAccessor)((Object)entity)).accessor$setLastPortalPos(new BlockPos(mEntity.getPosX(), mEntity.getPosY(), mEntity.getPosZ()));
                ((EntityAccessor)((Object)entity)).accessor$setTimeUntilPortal(Integer.MAX_VALUE);
                boolean bl5 = true;
                return bl5;
            }
            if (entity instanceof ServerPlayerEntity) {
                ((EntityAccessor)((Object)entity)).accessor$setTimeUntilPortal(Integer.MAX_VALUE);
                EntityUtil.performPostChangePlayerWorldLogic((ServerPlayerEntity)mEntity, (net.minecraft.world.server.ServerWorld)previousLocation.getWorld(), (net.minecraft.world.server.ServerWorld)destination.getWorld(), (net.minecraft.world.server.ServerWorld)actualDestination.getWorld(), false);
            } else {
                ((Entity)entity).detach();
                ((PlatformEntityBridge)((Object)entity)).bridge$remove(false);
                ((net.minecraft.world.server.ServerWorld)previousLocation.getWorld()).getProfiler().endSection();
                ((net.minecraft.world.server.ServerWorld)previousLocation.getWorld()).resetUpdateEntityTick();
                ((net.minecraft.world.server.ServerWorld)result.getEntityWorld()).resetUpdateEntityTick();
                ((net.minecraft.world.server.ServerWorld)previousLocation.getWorld()).getProfiler().endSection();
            }
            boolean bl6 = true;
            return bl6;
        }
    }
}

