/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.schematic;

import com.google.common.base.MoreObjects;
import com.google.common.collect.HashBiMap;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.biome.VirtualBiomeType;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.common.util.MemoizedSupplier;
import org.spongepowered.common.world.schematic.MutableBimapPalette;

public class GlobalPalette<T>
implements Palette.Immutable<T> {
    static final Supplier<GlobalPalette<BlockState>> GLOBAL_BLOCK_STATE_PALETTE = MemoizedSupplier.memoize(() -> new GlobalPalette<BlockState>(PaletteTypes.GLOBAL_BLOCK_PALETTE.get(), () -> Registry.BLOCK.stream().flatMap(block -> block.getStateContainer().getValidStates().stream()), type -> Block.BLOCK_STATE_IDS.get((Object)((net.minecraft.block.BlockState)type)), id -> (BlockState)Block.BLOCK_STATE_IDS.getByValue(id), BlockState.class));
    static final Supplier<GlobalPalette<BiomeType>> GLOBAL_BIOME_PALETTE = MemoizedSupplier.memoize(() -> new GlobalPalette<BiomeType>(PaletteTypes.GLOBAL_BIOME_PALETTE.get(), () -> Registry.BIOME.stream(), type -> Registry.BIOME.getId((Object)((Biome)(type instanceof VirtualBiomeType ? ((VirtualBiomeType)type).getPersistedType() : type))), id -> (BiomeType)Registry.BIOME.getByValue(id), BiomeType.class));
    private final ToIntFunction<T> typeToInt;
    private final IntFunction<T> intToType;
    private final PaletteType<T> paletteType;
    private final Class<T> catalogType;
    private final IntSupplier length = () -> ((Stream)catalogSupplier.get()).mapToInt(map).max().orElse(0);
    private final Supplier<Stream<T>> catalogSupplier;

    private GlobalPalette(PaletteType<T> paletteType, Supplier<Stream<T>> catalogSupplier, ToIntFunction<T> map, IntFunction<T> identity, Class<T> catalogType) {
        this.typeToInt = map;
        this.intToType = identity;
        this.paletteType = paletteType;
        this.catalogType = catalogType;
        this.catalogSupplier = catalogSupplier;
    }

    public static Palette<BlockState> getBlockPalette() {
        return GLOBAL_BLOCK_STATE_PALETTE.get();
    }

    public static GlobalPalette<BiomeType> getBiomePalette() {
        return GLOBAL_BIOME_PALETTE.get();
    }

    @Override
    public PaletteType<T> getType() {
        return this.paletteType;
    }

    @Override
    public int getHighestId() {
        return this.length.getAsInt();
    }

    @Override
    public OptionalInt get(T type) {
        return OptionalInt.of(this.typeToInt.applyAsInt(type));
    }

    @Override
    public Optional<T> get(int id) {
        return Optional.ofNullable(this.intToType.apply(id));
    }

    @Override
    public Stream<T> stream() {
        return this.catalogSupplier.get();
    }

    @Override
    public Palette.Mutable<T> asMutable() {
        HashBiMap copy = HashBiMap.create((int)this.length.getAsInt());
        this.catalogSupplier.get().map(it -> Tuple.of(it, this.typeToInt.applyAsInt(it))).forEach(tuple -> {
            Integer cfr_ignored_0 = (Integer)copy.put(tuple.getFirst(), tuple.getSecond());
        });
        return new MutableBimapPalette<T>(this.paletteType, copy);
    }

    public int hashCode() {
        return Objects.hash(this.paletteType, this.catalogType, this.length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalPalette other = (GlobalPalette)obj;
        return Objects.equals(this.paletteType, other.paletteType) && Objects.equals(this.catalogType, other.catalogType) && Objects.equals(this.length.getAsInt(), other.length.getAsInt());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("paletteType", this.paletteType).add("catalogType", this.catalogType).add("length", this.length.getAsInt()).toString();
    }
}

