/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.schematic;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Stream;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.common.world.schematic.MutableBimapPalette;

public class ImmutableBimapPalette<T>
implements Palette.Immutable<T> {
    private final ImmutableBiMap<Integer, T> ids;
    private final ImmutableBiMap<T, Integer> idsr;
    private final PaletteType<T> paletteType;
    private final int maxId;

    public ImmutableBimapPalette(PaletteType<T> paletteType, BiMap<Integer, T> reference) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        reference.forEach((arg_0, arg_1) -> ((ImmutableBiMap.Builder)builder).put(arg_0, arg_1));
        this.ids = builder.build();
        this.idsr = this.ids.inverse();
        this.paletteType = paletteType;
        int maxId = 0;
        for (Integer id : this.ids.keySet()) {
            if (maxId >= id) continue;
            maxId = id;
        }
        this.maxId = maxId;
    }

    @Override
    public PaletteType<T> getType() {
        return this.paletteType;
    }

    @Override
    public int getHighestId() {
        return this.maxId;
    }

    @Override
    public OptionalInt get(T state) {
        Integer value = (Integer)this.idsr.get(state);
        if (value == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(value);
    }

    @Override
    public Optional<T> get(int id) {
        return Optional.ofNullable(this.ids.get((Object)id));
    }

    @Override
    public Stream<T> stream() {
        return this.idsr.keySet().stream();
    }

    @Override
    public Palette.Mutable<T> asMutable() {
        return new MutableBimapPalette<T>(this.paletteType, this.idsr);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableBimapPalette that = (ImmutableBimapPalette)o;
        return this.maxId == that.maxId && this.ids.equals(that.ids) && this.paletteType.equals(that.paletteType);
    }

    public int hashCode() {
        return Objects.hash(this.ids, this.paletteType, this.maxId);
    }
}

