/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.schematic;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.common.util.SpongeCatalogBuilder;
import org.spongepowered.common.world.schematic.MutableBimapPalette;
import org.spongepowered.common.world.schematic.SpongePaletteType;

public class SpongePaletteTypeBuilder<T>
extends SpongeCatalogBuilder<PaletteType<T>, PaletteType.Builder<T>>
implements PaletteType.Builder<T> {
    private @MonotonicNonNull Function<T, String> encoder;
    private @MonotonicNonNull Function<String, Optional<T>> decoder;

    @Override
    public PaletteType.Builder<T> encoder(Function<T, String> encoder) {
        this.encoder = Objects.requireNonNull(encoder, "Encoder cannot be null");
        return this;
    }

    @Override
    public PaletteType.Builder<T> decoder(Function<String, Optional<T>> decoder) {
        this.decoder = Objects.requireNonNull(decoder, "Decoder cannot be null");
        return this;
    }

    @Override
    protected PaletteType<T> build(ResourceKey key) {
        Objects.requireNonNull(key, "ResourceKey cannot be null");
        Objects.requireNonNull(this.encoder, "Encoder cannot be null");
        Objects.requireNonNull(this.decoder, "Decoder cannot be null");
        return new SpongePaletteType<T>(key, () -> {
            PaletteType paletteType = Sponge.getRegistry().getCatalogRegistry().get(PaletteType.class, key).orElseThrow(() -> new IllegalStateException("PaletteType no longer registered, cannot create a Palette off an unregistered Palette Type"));
            return new MutableBimapPalette(paletteType);
        }, this.encoder, this.decoder);
    }
}

