/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.server;

import com.google.gson.JsonElement;
import java.nio.file.Path;
import net.minecraft.world.Difficulty;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.world.WorldArchetype;
import org.spongepowered.api.world.server.WorldManager;

public interface SpongeWorldManager
extends WorldManager {
    public static final ResourceKey VANILLA_OVERWORLD = ResourceKey.minecraft("overworld");
    public static final ResourceKey VANILLA_THE_NETHER = ResourceKey.minecraft("the_nether");
    public static final ResourceKey VANILLA_THE_END = ResourceKey.minecraft("the_end");

    public Path getSavesDirectory();

    public boolean registerPendingWorld(ResourceKey var1, WorldArchetype var2);

    public @Nullable ServerWorld getWorld(DimensionType var1);

    public @Nullable ServerWorld getWorld0(ResourceKey var1);

    public @Nullable ServerWorld getDefaultWorld();

    public void adjustWorldForDifficulty(ServerWorld var1, Difficulty var2, boolean var3);

    public void loadAllWorlds(String var1, String var2, long var3, WorldType var5, JsonElement var6, boolean var7, @Nullable WorldSettings var8, Difficulty var9);

    default public String getDirectoryName(ResourceKey key) {
        if (VANILLA_OVERWORLD.equals(key)) {
            return "";
        }
        if (VANILLA_THE_NETHER.equals(key)) {
            return "DIM-1";
        }
        if (VANILLA_THE_END.equals(key)) {
            return "DIM1";
        }
        return key.getValue();
    }
}

