/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.teleport;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.ChorusPlantBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EmptyBlockReader;
import net.minecraft.world.IBlockReader;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.world.teleport.TeleportHelperFilter;

public class DefaultTeleportHelperFilter
implements TeleportHelperFilter {
    private static final Set<Material> NOT_SAFE_FLOOR = ImmutableSet.of((Object)Material.AIR, (Object)Material.CACTUS, (Object)Material.FIRE, (Object)Material.LAVA);
    private final ResourceKey key;

    public DefaultTeleportHelperFilter() {
        this.key = ResourceKey.sponge("default");
    }

    public DefaultTeleportHelperFilter(ResourceKey key) {
        this.key = key;
    }

    @Override
    public ResourceKey getKey() {
        return this.key;
    }

    @Override
    public boolean isSafeFloorMaterial(BlockState blockState) {
        return !NOT_SAFE_FLOOR.contains(((net.minecraft.block.BlockState)blockState).getMaterial());
    }

    @Override
    public boolean isSafeBodyMaterial(BlockState blockState) {
        net.minecraft.block.BlockState state = (net.minecraft.block.BlockState)blockState;
        Material material = state.getMaterial();
        if (state.isSuffocating((IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.ZERO)) {
            return false;
        }
        if (material == Material.LAVA) {
            return false;
        }
        return !(state.getBlock() instanceof SlabBlock) && !(state.getBlock() instanceof CauldronBlock) && !(state.getBlock() instanceof AnvilBlock) && !(state.getBlock() instanceof FenceBlock) && !(state.getBlock() instanceof ChorusPlantBlock) && !(state.getBlock() instanceof SnowBlock) && material != Material.GLASS && material != Material.LEAVES;
    }
}

