/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.biome;

import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.world.biome.Biome;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.biome.VirtualBiomeType;
import org.spongepowered.api.world.volume.biome.ImmutableBiomeVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.biome.AbstractBiomeBuffer;
import org.spongepowered.math.vector.Vector3i;

public final class ObjectArrayImmutableBiomeBuffer
extends AbstractBiomeBuffer
implements ImmutableBiomeVolume {
    private final BiomeType[] biomes;

    public ObjectArrayImmutableBiomeBuffer(BiomeType[] biomes, Vector3i start, Vector3i size) {
        super(start, size);
        this.biomes = (BiomeType[])biomes.clone();
    }

    @Override
    public BiomeType getBiome(int x, int y, int z) {
        this.checkRange(x, y, z);
        return this.biomes[this.getIndex(x, y, z)];
    }

    public Biome getNativeBiome(int x, int y, int z) {
        this.checkRange(x, y, z);
        BiomeType type = this.biomes[this.getIndex(x, y, z)];
        if (type instanceof VirtualBiomeType) {
            type = ((VirtualBiomeType)type).getPersistedType();
        }
        return (Biome)type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectArrayImmutableBiomeBuffer that = (ObjectArrayImmutableBiomeBuffer)o;
        return Arrays.equals(this.biomes, that.biomes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.biomes);
        return result;
    }

    @Override
    public VolumeStream<ImmutableBiomeVolume, BiomeType> getBiomeStream(Vector3i min2, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(min2, max, options);
        Stream stateStream = IntStream.range(this.getBlockMin().getX(), this.getBlockMax().getX() + 1).mapToObj(x -> IntStream.range(this.getBlockMin().getZ(), this.getBlockMax().getZ() + 1).mapToObj(z -> IntStream.range(this.getBlockMin().getY(), this.getBlockMax().getY() + 1).mapToObj(y -> VolumeElement.of(this, () -> this.biomes[this.getIndex(x, y, z)], new Vector3i(x, y, z)))).flatMap(Function.identity())).flatMap(Function.identity());
        return new SpongeVolumeStream<ImmutableBiomeVolume, BiomeType>(stateStream, () -> this);
    }
}

