/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.serialize;

import io.leangen.geantyref.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.serialize.AbstractListChildSerializer;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.util.CheckedConsumer;

final class SetSerializer
extends AbstractListChildSerializer<Set<?>> {
    static final TypeToken<Set<?>> TYPE = new TypeToken<Set<?>>(){};

    SetSerializer() {
    }

    @Override
    Type elementType(Type containerType) throws SerializationException {
        if (!(containerType instanceof ParameterizedType)) {
            throw new SerializationException("Raw types are not supported for collections");
        }
        return ((ParameterizedType)containerType).getActualTypeArguments()[0];
    }

    @Override
    Set<?> createNew(int length, Type elementType) {
        return new LinkedHashSet(length);
    }

    @Override
    void forEachElement(Set<?> collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
        for (Object el : collection) {
            action.accept(el);
        }
    }

    @Override
    void deserializeSingle(int index, Set<?> collection, @Nullable Object deserialized) {
        collection.add(deserialized);
    }
}

