/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.applaunch.plugin;

import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.spongepowered.common.applaunch.plugin.PluginEngine;
import org.spongepowered.plugin.PluginCandidate;
import org.spongepowered.plugin.PluginEnvironment;
import org.spongepowered.plugin.PluginLanguageService;
import org.spongepowered.plugin.PluginResource;
import org.spongepowered.plugin.PluginResourceLocatorService;

public final class VanillaPluginEngine
implements PluginEngine {
    private final PluginEnvironment pluginEnvironment;
    private final Map<String, PluginResourceLocatorService<PluginResource>> locatorServices;
    private final Map<String, PluginLanguageService<PluginResource>> languageServices;
    private final Map<String, List<PluginResource>> locatorResources;
    private final Map<PluginLanguageService<PluginResource>, List<PluginCandidate<PluginResource>>> pluginCandidates;

    public VanillaPluginEngine(PluginEnvironment pluginEnvironment) {
        this.pluginEnvironment = pluginEnvironment;
        this.locatorServices = new HashMap<String, PluginResourceLocatorService<PluginResource>>();
        this.languageServices = new HashMap<String, PluginLanguageService<PluginResource>>();
        this.locatorResources = new HashMap<String, List<PluginResource>>();
        this.pluginCandidates = new IdentityHashMap<PluginLanguageService<PluginResource>, List<PluginCandidate<PluginResource>>>();
    }

    @Override
    public PluginEnvironment getPluginEnvironment() {
        return this.pluginEnvironment;
    }

    public Map<String, PluginResourceLocatorService<PluginResource>> getLocatorServices() {
        return Collections.unmodifiableMap(this.locatorServices);
    }

    public Map<String, PluginLanguageService<PluginResource>> getLanguageServices() {
        return Collections.unmodifiableMap(this.languageServices);
    }

    public Map<String, List<PluginResource>> getResources() {
        return Collections.unmodifiableMap(this.locatorResources);
    }

    public Map<PluginLanguageService<PluginResource>, List<PluginCandidate<PluginResource>>> getCandidates() {
        return this.pluginCandidates;
    }

    public void initialize() {
        for (Map.Entry<String, PluginLanguageService<PluginResource>> entry : this.languageServices.entrySet()) {
            entry.getValue().initialize(this.pluginEnvironment);
        }
    }

    public void discoverLocatorServices() {
        ServiceLoader<PluginResourceLocatorService> serviceLoader = ServiceLoader.load(PluginResourceLocatorService.class, null);
        Iterator<PluginResourceLocatorService> iter = serviceLoader.iterator();
        while (iter.hasNext()) {
            PluginResourceLocatorService next;
            try {
                next = iter.next();
            }
            catch (ServiceConfigurationError e) {
                this.pluginEnvironment.getLogger().error("Error encountered initializing plugin resource locator!", (Throwable)e);
                continue;
            }
            this.locatorServices.put(next.getName(), (PluginResourceLocatorService<PluginResource>)next);
        }
    }

    public void discoverLanguageServices() {
        ServiceLoader<PluginLanguageService> serviceLoader = ServiceLoader.load(PluginLanguageService.class, VanillaPluginEngine.class.getClassLoader());
        Iterator<PluginLanguageService> iter = serviceLoader.iterator();
        while (iter.hasNext()) {
            PluginLanguageService next;
            try {
                next = iter.next();
            }
            catch (ServiceConfigurationError e) {
                this.pluginEnvironment.getLogger().error("Error encountered initializing plugin language service!", (Throwable)e);
                continue;
            }
            this.languageServices.put(next.getName(), (PluginLanguageService<PluginResource>)next);
        }
    }

    public void locatePluginResources() {
        for (Map.Entry<String, PluginResourceLocatorService<PluginResource>> locatorEntry : this.locatorServices.entrySet()) {
            PluginResourceLocatorService<PluginResource> locatorService = locatorEntry.getValue();
            List resources = locatorService.locatePluginResources(this.pluginEnvironment);
            if (resources.isEmpty()) continue;
            this.locatorResources.put(locatorEntry.getKey(), resources);
        }
    }

    public void createPluginCandidates() {
        for (Map.Entry<String, PluginLanguageService<PluginResource>> languageEntry : this.languageServices.entrySet()) {
            PluginLanguageService<PluginResource> languageService = languageEntry.getValue();
            for (Map.Entry<String, List<PluginResource>> resourcesEntry : this.locatorResources.entrySet()) {
                for (PluginResource pluginResource : resourcesEntry.getValue()) {
                    try {
                        List candidates = languageService.createPluginCandidates(this.pluginEnvironment, pluginResource);
                        if (candidates.isEmpty()) continue;
                        this.pluginCandidates.computeIfAbsent(languageService, k -> new LinkedList()).addAll(candidates);
                    }
                    catch (ClassCastException classCastException) {}
                }
            }
        }
    }
}

