/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.client.gui.screen;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.metadata.PluginMetadata;
import org.spongepowered.vanilla.client.gui.widget.MetadataPanel;
import org.spongepowered.vanilla.client.gui.widget.list.PluginSelectionList;

public final class PluginScreen
extends Screen {
    private final Screen previousScreen;
    private final List<PluginMetadata> metadata;
    private PluginSelectionList selectionList;
    private MetadataPanel contentPanel;
    private TextFieldWidget searchField;

    public PluginScreen(Screen previousScreen) {
        super((ITextComponent)new StringTextComponent("Plugins"));
        this.previousScreen = previousScreen;
        this.metadata = new ObjectArrayList();
        Collection<PluginContainer> plugins = ((Launch)Launch.getInstance()).getPluginManager().getPlugins();
        this.metadata.addAll(plugins.stream().map(PluginContainer::getMetadata).collect(Collectors.toList()));
    }

    protected void init() {
        Minecraft.getInstance().keyboardListener.enableRepeatEvents(true);
        int listHeight = this.height - 122;
        this.selectionList = new PluginSelectionList(this, 4, 58, 175, listHeight, 26);
        this.contentPanel = new MetadataPanel(this.minecraft, this, this.width - this.selectionList.getWidth() - 12, listHeight, 58, this.selectionList.getRight() + 4);
        this.selectionList.setSelectConsumer(e -> this.contentPanel.setMetadata(e == null ? null : e.metadata));
        this.generateEntries(((Launch)Launch.getInstance()).getPluginManager().getPlugins().stream().map(PluginContainer::getMetadata).collect(Collectors.toList()));
        this.searchField = new TextFieldWidget(this.font, this.width / 2 - 100, 22, 200, 20, I18n.format((String)"itemGroup.search", (Object[])new Object[0]));
        this.searchField.setResponder(value -> this.selectionList.setFilterSupplier(() -> {
            List filteredList = this.selectionList.children().stream().filter(entry -> entry.metadata.getName().orElse("").toLowerCase().contains(value.toLowerCase()) || entry.metadata.getId().toLowerCase().contains(value.toLowerCase())).collect(Collectors.toList());
            if (!filteredList.contains(this.selectionList.getSelected())) {
                this.selectionList.setSelected(filteredList.stream().findFirst().orElse(null));
            }
            return filteredList;
        }));
        this.children.addAll(Arrays.asList(new AbstractGui[]{this.selectionList, this.contentPanel, this.searchField}));
        this.addButton((Widget)new Button(this.width / 2 - 50, this.height - 40, 100, 20, I18n.format((String)"gui.done", (Object[])new Object[0]), p_214323_1_ -> Minecraft.getInstance().displayGuiScreen(this.previousScreen)));
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        this.renderBackground();
        this.children.stream().filter(child -> child instanceof IRenderable).forEach(child -> ((IRenderable)child).render(p_render_1_, p_render_2_, p_render_3_));
        this.drawCenteredString(this.font, this.title.getString(), this.width / 2, 8, 0xFFFFFF);
        super.render(p_render_1_, p_render_2_, p_render_3_);
    }

    private void generateEntries(List<PluginMetadata> metadatas) {
        if (this.selectionList == null) {
            return;
        }
        this.selectionList.children().clear();
        this.selectionList.children().addAll(metadatas.stream().map(metadata -> new PluginSelectionList.Entry(this.selectionList, (PluginMetadata)metadata)).collect(Collectors.toList()));
        this.selectionList.setSelected(this.selectionList.children().stream().findFirst().orElse(null));
    }
}

