/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.hooks;

import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SJoinGamePacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldType;
import net.minecraft.world.dimension.DimensionType;
import org.spongepowered.api.world.dimension.DimensionTypes;
import org.spongepowered.common.bridge.entity.player.ServerPlayerEntityBridge;
import org.spongepowered.common.bridge.world.dimension.DimensionTypeBridge;
import org.spongepowered.common.entity.player.ClientType;
import org.spongepowered.common.hooks.PacketHooks;
import org.spongepowered.common.world.dimension.SpongeDimensionType;

public final class VanillaPacketHooks
implements PacketHooks {
    @Override
    public SJoinGamePacket createSJoinGamePacket(ServerPlayerEntity entity, GameType gameType, long seed, boolean hardcodeMode, DimensionType dimensionType, int maxPlayers, WorldType generatorType, int viewDistance, boolean isReducedDebugMode, boolean enableRespawnScreen) {
        if (((ServerPlayerEntityBridge)entity).bridge$getClientType() == ClientType.SPONGE_VANILLA) {
            return new SJoinGamePacket(entity.getEntityId(), gameType, seed, hardcodeMode, dimensionType, maxPlayers, generatorType, viewDistance, isReducedDebugMode, enableRespawnScreen);
        }
        SpongeDimensionType logicType = ((DimensionTypeBridge)dimensionType).bridge$getSpongeDimensionType();
        DimensionType clientType = DimensionTypes.OVERWORLD.get() == logicType ? DimensionType.OVERWORLD : (DimensionTypes.THE_NETHER.get() == logicType ? DimensionType.THE_NETHER : DimensionType.THE_END);
        return new SJoinGamePacket(entity.getEntityId(), gameType, seed, hardcodeMode, clientType, maxPlayers, generatorType, viewDistance, isReducedDebugMode, enableRespawnScreen);
    }

    @Override
    public SRespawnPacket createSRespawnPacket(ServerPlayerEntity entity, DimensionType dimensionType, long seed, WorldType worldType, GameType gameType) {
        if (((ServerPlayerEntityBridge)entity).bridge$getClientType() == ClientType.SPONGE_VANILLA) {
            return new SRespawnPacket(dimensionType, seed, worldType, gameType);
        }
        SpongeDimensionType logicType = ((DimensionTypeBridge)dimensionType).bridge$getSpongeDimensionType();
        DimensionType clientType = DimensionTypes.OVERWORLD.get() == logicType ? DimensionType.OVERWORLD : (DimensionTypes.THE_NETHER.get() == logicType ? DimensionType.THE_NETHER : DimensionType.THE_END);
        return new SRespawnPacket(clientType, seed, worldType, gameType);
    }
}

