/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.installer;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.cadixdev.atlas.Atlas;
import org.cadixdev.bombe.asm.jar.JarEntryRemappingTransformer;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.asm.LorenzRemapper;
import org.cadixdev.lorenz.io.MappingFormats;
import org.spongepowered.vanilla.installer.Installer;
import org.spongepowered.vanilla.installer.InstallerUtils;
import org.spongepowered.vanilla.installer.LauncherCommandLine;
import org.spongepowered.vanilla.installer.LibraryManager;
import org.spongepowered.vanilla.installer.model.mojang.Version;
import org.spongepowered.vanilla.installer.model.mojang.VersionManifest;

public final class InstallerMain {
    private final Installer installer;

    public InstallerMain(String[] args) throws Exception {
        LauncherCommandLine.configure(args);
        this.installer = new Installer(LogManager.getLogger("Installer"), LauncherCommandLine.installerDirectory);
    }

    public static void main(String[] args) throws Exception {
        new InstallerMain(args).run();
    }

    public void run() throws Exception {
        this.installer.getLibraryManager().validate();
        this.downloadMinecraft(LauncherCommandLine.librariesDirectory);
        Path srgZip = this.downloadSRG(LauncherCommandLine.librariesDirectory);
        Path minecraftJar = this.remapMinecraft(LauncherCommandLine.librariesDirectory, srgZip);
        this.installer.getLibraryManager().addLibrary(new LibraryManager.Library("minecraft", minecraftJar));
        this.installer.getLogger().info("Environment has been verified.");
        String javaBin = this.installer.getLauncherConfig().jvmDirectory.replace("${JAVA_HOME}", System.getProperty("java.home")) + File.separator + "bin" + File.separator + "java";
        List<String> jvmArgs = !this.installer.getLauncherConfig().jvmArgs.isEmpty() ? Arrays.asList(this.installer.getLauncherConfig().jvmArgs.split(" ")) : null;
        String depsClasspath = this.installer.getLibraryManager().getAll().values().stream().map(LibraryManager.Library::getFile).map(Path::toAbsolutePath).map(Path::normalize).map(Path::toString).collect(Collectors.joining(File.pathSeparator));
        String classpath = Paths.get(System.getProperty("java.class.path"), new String[0]).toAbsolutePath() + File.pathSeparator + depsClasspath + File.pathSeparator + minecraftJar.toAbsolutePath().normalize().toString();
        List<String> gameArgs = Arrays.asList(this.installer.getLauncherConfig().args.split(" "));
        this.installer.getLogger().debug("Setting classpath to: " + classpath);
        String className = "org.spongepowered.vanilla.applaunch.Main";
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaBin);
        if (jvmArgs != null) {
            command.addAll(jvmArgs);
        }
        command.add("-cp");
        command.add(classpath);
        command.add("org.spongepowered.vanilla.applaunch.Main");
        command.addAll(gameArgs);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        Process process = processBuilder.inheritIO().start();
        process.waitFor();
    }

    private void downloadMinecraft(Path librariesDirectory) throws Exception {
        Version version;
        Object manifest;
        this.installer.getLogger().info("Downloading the Minecraft versions manifest...");
        VersionManifest.Version foundVersionManifest = null;
        Gson gson = new Gson();
        try (JsonReader reader = new JsonReader(new InputStreamReader(new URL("https://launchermeta.mojang.com/mc/game/version_manifest.json").openStream()));){
            manifest = (VersionManifest)gson.fromJson(reader, (Type)((Object)VersionManifest.class));
            for (VersionManifest.Version version2 : ((VersionManifest)manifest).versions) {
                if (!"1.15.2".equals(version2.id)) continue;
                foundVersionManifest = version2;
                break;
            }
        }
        if (foundVersionManifest == null) {
            throw new IOException(String.format("Failed to find version manifest for '%s'!", "1.15.2"));
        }
        JsonReader reader = new JsonReader(new InputStreamReader(foundVersionManifest.url.openStream()));
        manifest = null;
        try {
            version = (Version)gson.fromJson(reader, (Type)((Object)Version.class));
        }
        catch (Throwable throwable) {
            manifest = throwable;
            throw throwable;
        }
        finally {
            if (reader != null) {
                if (manifest != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)manifest).addSuppressed(throwable);
                    }
                } else {
                    reader.close();
                }
            }
        }
        if (version == null) {
            throw new IOException(String.format("Failed to download version information for '%s'!", "1.15.2"));
        }
        Path downloadTarget = librariesDirectory.resolve("net/minecraft").resolve("1.15.2").resolve("minecraft_server.jar");
        if (Files.notExists(downloadTarget, new LinkOption[0])) {
            if (!this.installer.getLauncherConfig().autoDownloadLibraries) {
                throw new IOException(String.format("The Minecraft jar is not located at '%s' and downloading it has been turned off.", downloadTarget));
            }
            InstallerUtils.downloadCheckHash(this.installer.getLogger(), version.downloads.server.url, downloadTarget, MessageDigest.getInstance("SHA-1"), version.downloads.server.sha1, false);
        } else if (this.installer.getLauncherConfig().checkLibraryHashes) {
            this.installer.getLogger().info("Detected existing Minecraft Server jar, verifying hashes...");
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            byte[] bytes = Files.readAllBytes(downloadTarget);
            String fileSha1 = InstallerUtils.toHexString(sha1.digest(bytes));
            if (version.downloads.server.sha1.equals(fileSha1)) {
                this.installer.getLogger().info("Minecraft Server jar verified!");
            } else {
                this.installer.getLogger().error("Checksum verification failed: Expected {}, {}. Deleting cached Minecraft Server jar...", (Object)version.downloads.server.sha1, (Object)fileSha1);
                Files.delete(downloadTarget);
                InstallerUtils.downloadCheckHash(this.installer.getLogger(), version.downloads.server.url, downloadTarget, MessageDigest.getInstance("SHA-1"), version.downloads.server.sha1, false);
            }
        } else {
            this.installer.getLogger().info("Detected existing Minecraft jar. Skipping hash check as that is turned off...");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Path downloadSRG(Path librariesDirectory) throws IOException {
        this.installer.getLogger().info("Setting up MCP config for Minecraft {}", (Object)"1.15.2");
        Path downloadTarget = librariesDirectory.resolve("de/oceanlabs/mcp/mcp_config").resolve("1.15.2").resolve("mcp_config-1.15.2.zip");
        if (Files.notExists(downloadTarget, new LinkOption[0])) {
            URL mcpConfigUrl = new URL("https://files.minecraftforge.net/maven/de/oceanlabs/mcp/mcp_config/1.15.2/mcp_config-1.15.2.zip");
            if (!this.installer.getLauncherConfig().autoDownloadLibraries) throw new IOException(String.format("MCP config was not located at '%s' and downloading it has been turned off.", downloadTarget));
            InstallerUtils.download(this.installer.getLogger(), mcpConfigUrl, downloadTarget, false);
            return downloadTarget;
        } else {
            this.installer.getLogger().info("Detected existing MCP mappings, verifying hashes...");
            this.installer.getLogger().info("MCP mappings verified!");
        }
        return downloadTarget;
    }

    private Path remapMinecraft(Path librariesDirectory, Path srgZip) throws IOException {
        this.installer.getLogger().info("Checking if we need to remap Minecraft...");
        Path inputJar = librariesDirectory.resolve("net/minecraft").resolve("1.15.2").resolve("minecraft_server.jar");
        Path outputJar = librariesDirectory.resolve("net/minecraft").resolve("1.15.2").resolve("minecraft_server_remapped.jar");
        if (Files.exists(outputJar, new LinkOption[0])) {
            this.installer.getLogger().info("Remapped Minecraft detected, skipping...");
            return outputJar;
        }
        this.installer.getLogger().info("Remapping Minecraft to SRG. This may take a while...");
        try (FileSystem fileSystem = FileSystems.newFileSystem(srgZip, null);){
            Path srgFile = fileSystem.getPath("config/joined.tsrg", new String[0]);
            MappingSet mappings = MappingSet.create();
            MappingFormats.TSRG.read(mappings, srgFile);
            Atlas atlas = new Atlas();
            atlas.install(ctx -> new JarEntryRemappingTransformer(new LorenzRemapper(mappings, ctx.inheritanceProvider())));
            atlas.run(inputJar, outputJar);
        }
        return outputJar;
    }

    static {
        System.setProperty("log4j.configurationFile", "log4j2_launcher.xml");
    }
}

