/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.installer;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.spongepowered.vanilla.installer.Installer;
import org.spongepowered.vanilla.installer.InstallerUtils;
import org.spongepowered.vanilla.installer.LauncherCommandLine;
import org.spongepowered.vanilla.installer.model.sponge.Libraries;
import org.spongepowered.vanilla.installer.model.sponge.SonatypeResponse;

public final class LibraryManager {
    private final Installer installer;
    private final Path rootDirectory;
    private final Map<String, Library> libraries;

    public LibraryManager(Installer installer, Path rootDirectory) {
        this.installer = installer;
        this.rootDirectory = rootDirectory;
        this.libraries = new HashMap<String, Library>();
    }

    public Path getRootDirectory() {
        return this.rootDirectory;
    }

    public Map<String, Library> getAll() {
        return Collections.unmodifiableMap(this.libraries);
    }

    protected void addLibrary(Library library) {
        this.libraries.put(library.getName(), library);
    }

    public void validate() throws Exception {
        Libraries dependencies;
        this.installer.getLogger().info("Scanning and verifying libraries in '{}'. Please wait, this may take a moment...", (Object)LauncherCommandLine.librariesDirectory.toAbsolutePath());
        Gson gson = new Gson();
        try (JsonReader reader = new JsonReader(new InputStreamReader(this.getClass().getResourceAsStream("/libraries.json")));){
            dependencies = (Libraries)gson.fromJson(reader, (Type)((Object)Libraries.class));
        }
        ConcurrentHashMap.KeySetView downloadedDeps = ConcurrentHashMap.newKeySet();
        ArrayList<CompletableFuture<Object>> operations = new ArrayList<CompletableFuture<Object>>(dependencies.dependencies.size());
        ConcurrentHashMap.KeySetView failures = ConcurrentHashMap.newKeySet();
        ExecutorService workerPool = Executors.newFixedThreadPool(4);
        for (Libraries.Dependency dependency : dependencies.dependencies) {
            operations.add(this.asyncFailableFuture(() -> {
                String groupPath = dependency.group.replace(".", "/");
                Path depDirectory = this.rootDirectory.resolve(groupPath).resolve(dependency.module).resolve(dependency.version);
                Files.createDirectories(depDirectory, new FileAttribute[0]);
                Path depFile = depDirectory.resolve(dependency.module + "-" + dependency.version + ".jar");
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                boolean checkHashes = this.installer.getLauncherConfig().checkLibraryHashes;
                if (Files.exists(depFile, new LinkOption[0])) {
                    if (!checkHashes) {
                        this.installer.getLogger().info("Detected existing '{}', skipping hash checks...", (Object)depFile);
                        return null;
                    }
                    byte[] bytes = Files.readAllBytes(depFile);
                    String fileMd5 = InstallerUtils.toHexString(md5.digest(bytes));
                    if (dependency.md5.equals(fileMd5)) {
                        this.installer.getLogger().info("'{}' verified!", (Object)depFile);
                    } else {
                        this.installer.getLogger().error("Checksum verification failed: Expected {}, {}. Deleting cached '{}'...", (Object)dependency.md5, (Object)fileMd5, (Object)depFile);
                        Files.delete(depFile);
                        SonatypeResponse response = this.getResponseFor(gson, dependency);
                        if (response.items.isEmpty()) {
                            failures.add("No data received from '" + new URL(String.format("https://repo-new.spongepowered.org/service/rest/v1/search/assets?md5=%s&maven.groupId=%s&maven.artifactId=%s&maven.baseVersion=%s&maven.extension=jar", dependency.md5, dependency.group, dependency.module, dependency.version)) + "'!");
                            return null;
                        }
                        SonatypeResponse.Item item = response.items.get(0);
                        URL url = item.downloadUrl;
                        InstallerUtils.downloadCheckHash(this.installer.getLogger(), url, depFile, md5, item.checksum.md5, true);
                    }
                } else {
                    SonatypeResponse response = this.getResponseFor(gson, dependency);
                    if (response.items.isEmpty()) {
                        failures.add("No data received from '" + new URL(String.format("https://repo-new.spongepowered.org/service/rest/v1/search/assets?md5=%s&maven.groupId=%s&maven.artifactId=%s&maven.baseVersion=%s&maven.extension=jar", dependency.md5, dependency.group, dependency.module, dependency.version)) + "'!");
                        return null;
                    }
                    SonatypeResponse.Item item = response.items.get(0);
                    URL url = item.downloadUrl;
                    if (checkHashes) {
                        InstallerUtils.downloadCheckHash(this.installer.getLogger(), url, depFile, md5, item.checksum.md5, true);
                    } else {
                        InstallerUtils.download(this.installer.getLogger(), url, depFile, true);
                    }
                }
                downloadedDeps.add(new Library(dependency.group + "-" + dependency.module, depFile));
                return null;
            }, workerPool));
        }
        CompletableFuture.allOf(operations.toArray(new CompletableFuture[0])).join();
        workerPool.shutdown();
        if (!failures.isEmpty()) {
            this.installer.getLogger().error("Failed to download some libraries:");
            for (String message : failures) {
                this.installer.getLogger().error(message);
            }
            System.exit(-1);
        }
        for (Library library : downloadedDeps) {
            this.libraries.put(library.getName(), library);
        }
    }

    private SonatypeResponse getResponseFor(Gson gson, Libraries.Dependency dependency) throws IOException {
        URL requestUrl = new URL(String.format("https://repo-new.spongepowered.org/service/rest/v1/search/assets?md5=%s&maven.groupId=%s&maven.artifactId=%s&maven.baseVersion=%s&maven.extension=jar", dependency.md5, dependency.group, dependency.module, dependency.version));
        HttpURLConnection connection = (HttpURLConnection)requestUrl.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", "Sponge-Downloader");
        connection.connect();
        try (JsonReader reader = new JsonReader(new InputStreamReader(connection.getInputStream()));){
            SonatypeResponse sonatypeResponse = (SonatypeResponse)gson.fromJson(reader, (Type)((Object)SonatypeResponse.class));
            return sonatypeResponse;
        }
    }

    private <T> CompletableFuture<T> asyncFailableFuture(Callable<T> action, Executor executor) {
        CompletableFuture future = new CompletableFuture();
        executor.execute(() -> {
            try {
                future.complete(action.call());
            }
            catch (Exception ex) {
                future.completeExceptionally(ex);
            }
        });
        return future;
    }

    public static class Library {
        private final String name;
        private final Path file;

        public Library(String name, Path file) {
            this.name = name;
            this.file = file;
        }

        public String getName() {
            return this.name;
        }

        public Path getFile() {
            return this.file;
        }
    }
}

