/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.mixin.core.crash;

import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import org.spongepowered.api.Sponge;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.metadata.PluginMetadata;

@Mixin(value={CrashReport.class})
public abstract class CrashReportMixin_Vanilla {
    @Shadow
    @Final
    private CrashReportCategory systemDetailsCategory;

    @Inject(method={"populateEnvironment"}, at={@At(value="RETURN")})
    private void vanilla$addPluginsToEnvironment(CallbackInfo ci) {
        this.systemDetailsCategory.addDetail("Plugins", () -> {
            StringBuilder result = new StringBuilder(64);
            for (PluginContainer container : Sponge.getPluginManager().getPlugins()) {
                PluginMetadata metadata = container.getMetadata();
                String name = metadata.getName().orElse(metadata.getId());
                result.append("\n\t\t").append(name).append(" (").append(metadata.getId()).append(") ").append(metadata.getVersion());
            }
            return result.toString();
        });
    }
}

