/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.mixin.core.server.integrated;

import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.net.Proxy;
import net.minecraft.client.Minecraft;
import net.minecraft.command.Commands;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.listener.IChunkStatusListenerFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeBootstrap;
import org.spongepowered.common.SpongeLifecycle;
import org.spongepowered.common.bridge.server.MinecraftServerBridge;
import org.spongepowered.vanilla.VanillaServer;

@Mixin(value={IntegratedServer.class})
public abstract class IntegratedServerMixin_Vanilla
extends MinecraftServer
implements MinecraftServerBridge,
VanillaServer {
    @Shadow
    @Final
    private Minecraft mc;
    @Shadow
    @Final
    private WorldSettings worldSettings;
    @Shadow
    private boolean isGamePaused;

    public IntegratedServerMixin_Vanilla(File p_i50590_1_, Proxy p_i50590_2_, DataFixer dataFixerIn, Commands p_i50590_4_, YggdrasilAuthenticationService p_i50590_5_, MinecraftSessionService p_i50590_6_, GameProfileRepository p_i50590_7_, PlayerProfileCache p_i50590_8_, IChunkStatusListenerFactory p_i50590_9_, String p_i50590_10_) {
        super(p_i50590_1_, p_i50590_2_, dataFixerIn, p_i50590_4_, p_i50590_5_, p_i50590_6_, p_i50590_7_, p_i50590_8_, p_i50590_9_, p_i50590_10_);
    }

    public void run() {
        SpongeLifecycle lifecycle = SpongeBootstrap.getLifecycle();
        lifecycle.establishServerServices();
        lifecycle.establishServerFeatures();
        lifecycle.establishCommands();
        lifecycle.callStartingEngineEvent(this);
        super.run();
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    private void vanilla$callEngineStartedAndLoadedGame(CallbackInfoReturnable<Boolean> cir) {
        SpongeLifecycle lifecycle = SpongeBootstrap.getLifecycle();
        lifecycle.callStartedEngineEvent(this);
    }

    public void loadAllWorlds(String saveName, String worldNameIn, long seed, WorldType type, JsonElement generatorOptions) {
        this.getWorldManager().loadAllWorlds(saveName, worldNameIn, seed, type, generatorOptions, true, this.worldSettings, this.mc.gameSettings.difficulty);
    }

    @Override
    public boolean bridge$performAutosaveChecks() {
        if (!this.isServerRunning()) {
            return false;
        }
        return !this.isGamePaused;
    }
}

