/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data;

import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.util.CopyableBuilder;

public interface KeyValueMatcher<V>
extends DataSerializable {
    public static <V> KeyValueMatcher<V> of(Key<? extends Value<V>> key, V value) {
        return KeyValueMatcher.of(key, value, Operator.EQUAL);
    }

    public static <V> KeyValueMatcher<V> of(Key<? extends Value<V>> key, V value, Operator operator) {
        return KeyValueMatcher.builder().key(key).value(value).operator(operator).build();
    }

    public static Builder<?> builder() {
        return Sponge.getGame().getBuilderProvider().provide(Builder.class);
    }

    public Key<? extends Value<V>> getKey();

    public Operator getOperator();

    public Optional<V> getValue();

    default public boolean matchesContainer(ValueContainer valueContainer) {
        Objects.requireNonNull(valueContainer, "valueContainer");
        return this.matches(valueContainer.get(this.getKey()).orElse(null));
    }

    public boolean matches(@Nullable V var1);

    public static interface Builder<V>
    extends org.spongepowered.api.util.Builder<KeyValueMatcher<V>, Builder<V>>,
    CopyableBuilder<KeyValueMatcher<V>, Builder<V>>,
    DataBuilder<KeyValueMatcher<V>> {
        public <NV> Builder<NV> key(Key<? extends Value<NV>> var1);

        public Builder<V> operator(Operator var1);

        public Builder<V> value(@Nullable V var1);

        public Builder<V> value(@Nullable Value<? extends V> var1);

        public KeyValueMatcher<V> build();
    }

    public static enum Operator {
        EQUAL,
        NOT_EQUAL,
        GREATER,
        GREATER_OR_EQUAL,
        LESS,
        LESS_OR_EQUAL,
        INCLUDES,
        EXCLUDES;

    }
}

