/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.inventory.type;

import java.util.Optional;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.math.vector.Vector2i;

public interface Inventory2D
extends Inventory {
    default public InventoryTransactionResult.Poll poll(Vector2i pos) {
        return this.getSlot(pos).map(Inventory::poll).orElse(InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.NO_SLOT).poll(ItemStackSnapshot.empty()).build());
    }

    default public InventoryTransactionResult.Poll poll(Vector2i pos, int limit) {
        return this.getSlot(pos).map(slot -> slot.poll(limit)).orElse(InventoryTransactionResult.builder().type(InventoryTransactionResult.Type.NO_SLOT).poll(ItemStackSnapshot.empty()).build());
    }

    default public Optional<ItemStack> peek(Vector2i pos) {
        return this.getSlot(pos).map(Inventory::peek);
    }

    default public InventoryTransactionResult set(Vector2i pos, ItemStack stack) {
        return this.getSlot(pos).map(slot -> slot.set(stack)).orElse(InventoryTransactionResult.failNoTransactions());
    }

    public Optional<Slot> getSlot(Vector2i var1);
}

