/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.recipe;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.Recipe;
import org.spongepowered.api.item.recipe.RecipeType;
import org.spongepowered.api.item.recipe.cooking.CookingRecipe;
import org.spongepowered.api.item.recipe.crafting.RecipeResult;
import org.spongepowered.api.world.server.ServerWorld;

public interface RecipeRegistry {
    public Optional<Recipe> getByKey(ResourceKey var1);

    public Collection<Recipe> getAll();

    public <T extends Recipe> Collection<T> getAllOfType(RecipeType<T> var1);

    default public <T extends Recipe> Collection<T> getAllOfType(Supplier<? extends RecipeType<T>> supplier) {
        return this.getAllOfType(supplier.get());
    }

    public <T extends Recipe> Collection<T> findByResult(RecipeType<T> var1, ItemStackSnapshot var2);

    default public <T extends Recipe> Collection<T> findByResult(Supplier<? extends RecipeType<T>> supplier, ItemStackSnapshot result) {
        return this.findByResult(supplier.get(), result);
    }

    public Optional<Recipe> findMatchingRecipe(Inventory var1, ServerWorld var2);

    public <T extends Recipe> Optional<T> findMatchingRecipe(RecipeType<T> var1, Inventory var2, ServerWorld var3);

    default public <T extends Recipe> Optional<T> findMatchingRecipe(Supplier<? extends RecipeType<T>> supplier, Inventory inventory, ServerWorld world) {
        return this.findMatchingRecipe(supplier.get(), inventory, world);
    }

    public <T extends CookingRecipe> Optional<T> findCookingRecipe(RecipeType<T> var1, ItemStackSnapshot var2);

    default public <T extends CookingRecipe> Optional<T> findCookingRecipe(Supplier<? extends RecipeType<T>> supplier, ItemStackSnapshot ingredient) {
        return this.findCookingRecipe(supplier.get(), ingredient);
    }

    default public Optional<RecipeResult> getResult(Inventory inventory, ServerWorld world) {
        return this.findMatchingRecipe(inventory, world).flatMap(recipe -> recipe.getResult(inventory, world));
    }
}

