/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.recipe.crafting;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.registry.DefaultedRegistryReference;

public interface Ingredient
extends Predicate<ItemStack> {
    public static Ingredient empty() {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).empty();
    }

    @Override
    public boolean test(ItemStack var1);

    public List<ItemStackSnapshot> displayedItems();

    public static Builder builder() {
        return Sponge.getGame().getBuilderProvider().provide(Builder.class);
    }

    public static Ingredient of(ItemType ... itemTypes) {
        if (itemTypes == null || itemTypes.length == 0) {
            return Ingredient.empty();
        }
        return Ingredient.builder().with(itemTypes).build();
    }

    public static Ingredient of(ItemStack ... items) {
        if (items == null || items.length == 0) {
            return Ingredient.empty();
        }
        return Ingredient.builder().with(items).build();
    }

    public static Ingredient of(ItemStackSnapshot ... items) {
        if (items == null) {
            return Ingredient.empty();
        }
        return Ingredient.builder().with(items).build();
    }

    @SafeVarargs
    public static Ingredient of(DefaultedRegistryReference<? extends ItemType> ... itemTypes) {
        if (itemTypes == null || itemTypes.length == 0) {
            return Ingredient.empty();
        }
        return Ingredient.builder().with(itemTypes).build();
    }

    public static Ingredient of(ResourceKey key, Predicate<ItemStack> predicate, ItemStack ... exemplaryStacks) {
        if (exemplaryStacks.length == 0) {
            throw new IllegalArgumentException("At least exemplary stack is required");
        }
        return Ingredient.builder().with(key, predicate, exemplaryStacks).build();
    }

    public static Ingredient of(ResourceKey key) {
        return Ingredient.builder().with(key).build();
    }

    public static interface Factory {
        public Ingredient empty();
    }

    public static interface Builder
    extends org.spongepowered.api.util.Builder<Ingredient, Builder> {
        public Builder with(ItemType ... var1);

        public Builder with(Supplier<? extends ItemType> ... var1);

        public Builder with(ItemStack ... var1);

        public Builder with(ResourceKey var1, Predicate<ItemStack> var2, ItemStack ... var3);

        public Builder with(ItemStackSnapshot ... var1);

        public Builder with(ResourceKey var1);

        public Ingredient build();
    }
}

