/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.profile;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.kyori.adventure.identity.Identity;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.profile.property.ProfileProperty;
import org.spongepowered.api.util.Identifiable;

public interface GameProfile
extends Identifiable,
Identity,
DataSerializable {
    public static GameProfile of(UUID uniqueId) {
        return GameProfile.of(uniqueId, null);
    }

    public static GameProfile of(UUID uniqueId, @Nullable String name) {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).of(uniqueId, name);
    }

    default public UUID uuid() {
        return this.getUniqueId();
    }

    public Optional<String> getName();

    default public boolean hasName() {
        return this.getName().isPresent();
    }

    public GameProfile withName(@Nullable String var1);

    public List<ProfileProperty> getProperties();

    public GameProfile withoutProperties();

    public GameProfile withProperties(Iterable<ProfileProperty> var1);

    public GameProfile withProperty(ProfileProperty var1);

    public GameProfile withoutProperties(Iterable<ProfileProperty> var1);

    default public GameProfile withoutProperties(String name) {
        return this.withoutProperties((ProfileProperty property) -> property.getName().equals(name));
    }

    public GameProfile withoutProperty(ProfileProperty var1);

    public GameProfile withoutProperties(Predicate<ProfileProperty> var1);

    public static interface Factory {
        public GameProfile of(UUID var1, @Nullable String var2);
    }
}

