/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.scheduler;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.Collection;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.api.scheduler.ScheduledUpdate;
import org.spongepowered.api.scheduler.TaskPriorities;
import org.spongepowered.api.scheduler.TaskPriority;
import org.spongepowered.math.vector.Vector3i;

public interface ScheduledUpdateList<T> {
    default public ScheduledUpdate<T> schedule(Vector3i pos, T target, int delay, TemporalUnit temporalUnit) {
        return this.schedule(pos.getX(), pos.getY(), pos.getZ(), target, delay, temporalUnit, TaskPriorities.NORMAL.get());
    }

    default public ScheduledUpdate<T> schedule(Vector3i pos, T target, Duration delay) {
        return this.schedule(pos.getX(), pos.getY(), pos.getZ(), target, delay, TaskPriorities.NORMAL);
    }

    default public ScheduledUpdate<T> schedule(int x, int y, int z, T target, int delay, TemporalUnit temporalUnit) {
        return this.schedule(x, y, z, target, delay, temporalUnit, TaskPriorities.NORMAL.get());
    }

    default public ScheduledUpdate<T> schedule(int x, int y, int z, T target, Duration delay) {
        return this.schedule(x, y, z, target, delay, TaskPriorities.NORMAL);
    }

    default public ScheduledUpdate<T> schedule(Vector3i pos, T target, int delay, TemporalUnit temporalUnit, TaskPriority priority) {
        return this.schedule(pos.getX(), pos.getY(), pos.getZ(), target, Duration.of(delay, temporalUnit), priority);
    }

    default public ScheduledUpdate<T> schedule(Vector3i pos, T target, int delay, TemporalUnit temporalUnit, DefaultedRegistryReference<? extends TaskPriority> priority) {
        return this.schedule(pos.getX(), pos.getY(), pos.getZ(), target, Duration.of(delay, temporalUnit), priority.get());
    }

    default public ScheduledUpdate<T> schedule(Vector3i pos, T target, Duration delay, TaskPriority priority) {
        return this.schedule(pos.getX(), pos.getY(), pos.getZ(), target, delay, priority);
    }

    default public ScheduledUpdate<T> schedule(Vector3i pos, T target, Duration delay, DefaultedRegistryReference<? extends TaskPriority> priority) {
        return this.schedule(pos.getX(), pos.getY(), pos.getZ(), target, delay, priority.get());
    }

    default public ScheduledUpdate<T> schedule(int x, int y, int z, T target, int delay, TemporalUnit temporalUnit, TaskPriority priority) {
        return this.schedule(x, y, z, target, Duration.of(delay, temporalUnit), priority);
    }

    default public ScheduledUpdate<T> schedule(int x, int y, int z, T target, int delay, TemporalUnit temporalUnit, DefaultedRegistryReference<? extends TaskPriority> priority) {
        return this.schedule(x, y, z, target, Duration.of(delay, temporalUnit), priority.get());
    }

    public ScheduledUpdate<T> schedule(int var1, int var2, int var3, T var4, Duration var5, TaskPriority var6);

    default public ScheduledUpdate<T> schedule(int x, int y, int z, T target, Duration delay, DefaultedRegistryReference<? extends TaskPriority> priority) {
        return this.schedule(x, y, z, target, delay, priority.get());
    }

    default public boolean isScheduled(Vector3i pos, T target) {
        return this.isScheduled(pos.getX(), pos.getY(), pos.getZ(), target);
    }

    public boolean isScheduled(int var1, int var2, int var3, T var4);

    default public Collection<? extends ScheduledUpdate<T>> getScheduledAt(Vector3i pos) {
        return this.getScheduledAt(pos.getX(), pos.getY(), pos.getZ());
    }

    public Collection<? extends ScheduledUpdate<T>> getScheduledAt(int var1, int var2, int var3);
}

