/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.scoreboard;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.criteria.Criterion;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.util.CopyableBuilder;

public interface Scoreboard {
    public static Builder builder() {
        return Sponge.getGame().getBuilderProvider().provide(Builder.class);
    }

    public Optional<Objective> getObjective(String var1);

    default public Optional<Objective> getObjective(Supplier<? extends DisplaySlot> slot) {
        return this.getObjective(slot.get());
    }

    public Optional<Objective> getObjective(DisplaySlot var1);

    public void addObjective(Objective var1) throws IllegalArgumentException;

    default public void updateDisplaySlot(@Nullable Objective objective, DefaultedRegistryReference<? extends DisplaySlot> displaySlot) throws IllegalStateException {
        this.updateDisplaySlot(objective, displaySlot.get());
    }

    public void updateDisplaySlot(@Nullable Objective var1, DisplaySlot var2) throws IllegalStateException;

    default public void clearSlot(Supplier<? extends DisplaySlot> slot) {
        this.clearSlot(slot.get());
    }

    default public void clearSlot(DisplaySlot slot) {
        this.updateDisplaySlot(null, slot);
    }

    default public Set<Objective> getObjectivesByCriterion(Supplier<? extends Criterion> criterion) {
        return this.getObjectivesByCriterion(criterion.get());
    }

    public Set<Objective> getObjectivesByCriterion(Criterion var1);

    public Set<Objective> getObjectives();

    public void removeObjective(Objective var1);

    public Set<Score> getScores();

    public Set<Score> getScores(Component var1);

    public void removeScores(Component var1);

    public Optional<Team> getTeam(String var1);

    public void registerTeam(Team var1) throws IllegalArgumentException;

    public Set<Team> getTeams();

    public Optional<Team> getMemberTeam(Component var1);

    public static interface Builder
    extends org.spongepowered.api.util.Builder<Scoreboard, Builder>,
    CopyableBuilder<Scoreboard, Builder> {
        public Builder objectives(List<Objective> var1);

        public Builder teams(List<Team> var1);

        public Scoreboard build() throws IllegalStateException;
    }
}

