/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.spongepowered.api.Engine;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.util.Ticks;

public interface MinecraftDayTime {
    public static MinecraftDayTime minecraftEpoch() {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).epoch();
    }

    public static MinecraftDayTime ofInGameDuration(Engine engine, Duration duration) {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).of(engine, duration);
    }

    public static MinecraftDayTime ofWallClockDuration(Engine engine, Duration duration) {
        return MinecraftDayTime.of(engine, Ticks.ofWallClockTime(engine, duration.toMillis(), ChronoUnit.MILLIS));
    }

    public static MinecraftDayTime of(int day, int hours, int minutes) {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).of(day, hours, minutes);
    }

    public static MinecraftDayTime of(Engine engine, Ticks ticks) {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).of(engine, ticks);
    }

    public int day();

    public int hour();

    public int minute();

    public MinecraftDayTime add(Ticks var1);

    public MinecraftDayTime add(int var1, int var2, int var3);

    public MinecraftDayTime subtract(Ticks var1);

    public MinecraftDayTime subtract(int var1, int var2, int var3);

    public Duration asInGameDuration();

    default public Duration asWallClockDuration(Engine engine) {
        return this.asTicks().getExpectedDuration(engine);
    }

    public Ticks asTicks();

    public static interface Factory {
        public MinecraftDayTime epoch();

        public MinecraftDayTime of(Engine var1, Duration var2);

        public MinecraftDayTime of(int var1, int var2, int var3);

        public MinecraftDayTime of(Engine var1, Ticks var2);
    }
}

