/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.schematic;

import java.util.Objects;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.world.schematic.PaletteType;

public interface PaletteReference<T, R> {
    public RegistryType<R> registry();

    public String value();

    default public Optional<T> resolve(RegistryHolder holder, PaletteType<T, R> type) {
        return type.getResolver().apply(this.value(), holder.registry(this.registry()));
    }

    public static <T, R> PaletteReference<T, R> byString(RegistryType<R> registryType, String value) {
        String stringId = Objects.requireNonNull(value, "String cannot be null!");
        if (stringId.isEmpty()) {
            throw new IllegalArgumentException("String cannot be empty to refer to an object in a Palette");
        }
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).stringReference(Objects.requireNonNull(registryType, "RegistryType cannot be null!"), stringId);
    }

    public static interface Factory {
        public <T, R> PaletteReference<T, R> stringReference(RegistryType<R> var1, String var2);
    }
}

