/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.biome;

import java.util.Objects;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.volume.ImmutableVolume;
import org.spongepowered.api.world.volume.MutableVolume;
import org.spongepowered.api.world.volume.UnmodifiableVolume;
import org.spongepowered.api.world.volume.Volume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.math.vector.Vector3i;

public interface BiomeVolume
extends Volume {
    default public Biome getBiome(Vector3i position) {
        Objects.requireNonNull(position, "position");
        return this.getBiome(position.getX(), position.getY(), position.getZ());
    }

    public Biome getBiome(int var1, int var2, int var3);

    public static interface Immutable
    extends Unmodifiable<Immutable>,
    ImmutableVolume {
    }

    public static interface Mutable<M extends Mutable<M>>
    extends Streamable<M>,
    MutableVolume {
        default public boolean setBiome(Vector3i position, Biome biome) {
            return this.setBiome(position.getX(), position.getY(), position.getZ(), biome);
        }

        public boolean setBiome(int var1, int var2, int var3, Biome var4);
    }

    public static interface Unmodifiable<U extends Unmodifiable<U>>
    extends BiomeVolume,
    Streamable<U>,
    UnmodifiableVolume {
    }

    public static interface Streamable<B extends Streamable<B>>
    extends BiomeVolume {
        public VolumeStream<B, Biome> getBiomeStream(Vector3i var1, Vector3i var2, StreamOptions var3);
    }
}

