/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.nio.file.Path;
import java.util.Locale;
import org.spongepowered.api.Client;
import org.spongepowered.api.Game;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Server;
import org.spongepowered.api.asset.AssetManager;
import org.spongepowered.api.data.DataManager;
import org.spongepowered.api.event.EventManager;
import org.spongepowered.api.network.channel.ChannelRegistry;
import org.spongepowered.api.plugin.PluginManager;
import org.spongepowered.api.registry.BuilderProvider;
import org.spongepowered.api.registry.FactoryProvider;
import org.spongepowered.api.registry.GameRegistry;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryScope;
import org.spongepowered.api.service.ServiceProvider;
import org.spongepowered.api.sql.SqlManager;
import org.spongepowered.api.util.metric.MetricsConfigManager;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.config.PluginConfigManager;
import org.spongepowered.common.registry.SpongeRegistryHolder;
import org.spongepowered.common.scheduler.AsyncScheduler;
import org.spongepowered.common.server.ServerConsoleSystemSubject;
import org.spongepowered.common.util.LocaleCache;

@Singleton
public final class SpongeGame
implements Game {
    private final Platform platform;
    private final GameRegistry registry;
    private final BuilderProvider builderProvider;
    private final FactoryProvider factoryProvider;
    private final DataManager dataManager;
    private final PluginManager pluginManager;
    private final EventManager eventManager;
    private final AssetManager assetManager;
    private final PluginConfigManager configManager;
    private final ChannelRegistry channelRegistry;
    private final MetricsConfigManager metricsConfigManager;
    private final SqlManager sqlManager;
    private final ServiceProvider.GameScoped serviceProvider;
    private final AsyncScheduler asyncScheduler;
    private RegistryHolder registryHolder;
    private Client client;
    private Server server;
    private ServerConsoleSystemSubject systemSubject;

    @Inject
    public SpongeGame(Platform platform, GameRegistry registry, BuilderProvider builderProvider, FactoryProvider factoryProvider, DataManager dataManager, PluginManager pluginManager, EventManager eventManager, AssetManager assetManager, PluginConfigManager configManager, ChannelRegistry channelRegistry, MetricsConfigManager metricsConfigManager, SqlManager sqlManager, ServiceProvider.GameScoped serviceProvider) {
        this.platform = platform;
        this.registry = registry;
        this.builderProvider = builderProvider;
        this.factoryProvider = factoryProvider;
        this.dataManager = dataManager;
        this.pluginManager = pluginManager;
        this.eventManager = eventManager;
        this.assetManager = assetManager;
        this.configManager = configManager;
        this.channelRegistry = channelRegistry;
        this.metricsConfigManager = metricsConfigManager;
        this.sqlManager = sqlManager;
        this.serviceProvider = serviceProvider;
        this.asyncScheduler = new AsyncScheduler();
    }

    @Override
    public Path getGameDirectory() {
        return SpongeCommon.getGameDirectory();
    }

    @Override
    public ServerConsoleSystemSubject getSystemSubject() {
        if (this.systemSubject == null) {
            this.systemSubject = new ServerConsoleSystemSubject();
        }
        return this.systemSubject;
    }

    @Override
    public Platform getPlatform() {
        return this.platform;
    }

    @Override
    public GameRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public BuilderProvider getBuilderProvider() {
        return this.builderProvider;
    }

    @Override
    public FactoryProvider getFactoryProvider() {
        return this.factoryProvider;
    }

    @Override
    public DataManager getDataManager() {
        return this.dataManager;
    }

    @Override
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    public AssetManager getAssetManager() {
        return this.assetManager;
    }

    @Override
    public PluginConfigManager getConfigManager() {
        return this.configManager;
    }

    @Override
    public ChannelRegistry getChannelRegistry() {
        return this.channelRegistry;
    }

    @Override
    public MetricsConfigManager getMetricsConfigManager() {
        return this.metricsConfigManager;
    }

    @Override
    public SqlManager getSqlManager() {
        return this.sqlManager;
    }

    @Override
    public ServiceProvider.GameScoped getServiceProvider() {
        return this.serviceProvider;
    }

    @Override
    public AsyncScheduler getAsyncScheduler() {
        return this.asyncScheduler;
    }

    @Override
    public Locale getLocale(String locale) {
        return LocaleCache.getLocale((String)Preconditions.checkNotNull((Object)locale));
    }

    @Override
    public boolean isServerAvailable() {
        if (this.client != null) {
            return this.client.getServer().isPresent();
        }
        return this.server != null;
    }

    @Override
    public Server getServer() {
        if (this.client != null) {
            return this.client.getServer().orElseThrow(() -> new IllegalStateException("The singleplayer server is not available!"));
        }
        Preconditions.checkState((this.server != null ? 1 : 0) != 0, (Object)"The dedicated server is not available!");
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    @Override
    public boolean isClientAvailable() {
        return this.client != null;
    }

    @Override
    public Client getClient() {
        Preconditions.checkState((this.client != null ? 1 : 0) != 0, (Object)"The client is not available!");
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    @Override
    public RegistryScope registryScope() {
        return RegistryScope.GAME;
    }

    @Override
    public RegistryHolder registries() {
        if (this.registryHolder == null) {
            this.registryHolder = new SpongeRegistryHolder();
        }
        return this.registryHolder;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("platform", (Object)this.platform).toString();
    }
}

