/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common;

import co.aikar.timings.TimingsFactory;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import io.leangen.geantyref.TypeToken;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.util.registry.Registry;
import org.spongepowered.api.Client;
import org.spongepowered.api.Engine;
import org.spongepowered.api.Game;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.bridge.server.MinecraftServerBridge;
import org.spongepowered.common.command.manager.SpongeCommandManager;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.datapack.SpongeDataPackManager;
import org.spongepowered.common.event.SpongeEventManager;
import org.spongepowered.common.event.lifecycle.AbstractRegisterRegistryEvent;
import org.spongepowered.common.event.lifecycle.AbstractRegisterRegistryValueEvent;
import org.spongepowered.common.event.lifecycle.RegisterBuilderEventImpl;
import org.spongepowered.common.event.lifecycle.RegisterDataEventImpl;
import org.spongepowered.common.event.lifecycle.RegisterFactoryEventImpl;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.launch.plugin.DummyPluginContainer;
import org.spongepowered.common.network.channel.SpongeChannelRegistry;
import org.spongepowered.common.registry.SpongeBuilderProvider;
import org.spongepowered.common.registry.SpongeFactoryProvider;
import org.spongepowered.common.registry.SpongeRegistries;
import org.spongepowered.common.registry.SpongeRegistryHolder;
import org.spongepowered.common.relocate.co.aikar.timings.SpongeTimingsFactory;
import org.spongepowered.common.service.SpongeServiceProvider;
import org.spongepowered.plugin.PluginContainer;

@Singleton
public final class SpongeLifecycle {
    private final Game game;
    private final Injector injector;

    @Inject
    public SpongeLifecycle(Game game, Injector injector) {
        this.game = game;
        this.injector = injector;
    }

    public void establishFactories() {
        ((SpongeFactoryProvider)this.game.getFactoryProvider()).registerDefaultFactories();
    }

    public void establishBuilders() {
        ((SpongeBuilderProvider)this.game.getBuilderProvider()).registerDefaultBuilders();
        ((SpongeDataManager)this.game.getDataManager()).registerDefaultBuilders();
    }

    public void callRegisterFactoryEvent() {
        this.game.getEventManager().post(new RegisterFactoryEventImpl(Cause.of(EventContext.empty(), this.game), this.game));
    }

    public void callRegisterBuilderEvent() {
        this.game.getEventManager().post(new RegisterBuilderEventImpl(Cause.of(EventContext.empty(), this.game), this.game));
    }

    public void establishGlobalRegistries() {
        SpongeRegistryHolder holder = (SpongeRegistryHolder)this.game.registries();
        holder.setRootMinecraftRegistry(Registry.field_212617_f);
        SpongeRegistries.registerGlobalRegistries((SpongeRegistryHolder)this.game.registries());
        this.game.getEventManager().post(new AbstractRegisterRegistryEvent.GameScopedImpl(Cause.of(EventContext.empty(), this.game), this.game));
        this.game.getEventManager().post(new AbstractRegisterRegistryValueEvent.GameScopedImpl(Cause.of(EventContext.empty(), this.game), this.game));
    }

    public void callRegisterDataEvent() {
        this.game.getEventManager().post(new RegisterDataEventImpl(Cause.of(EventContext.empty(), Sponge.getGame()), Sponge.getGame(), (SpongeDataManager)this.game.getDataManager()));
    }

    public void establishDataProviders() {
        ((SpongeDataManager)this.game.getDataManager()).registerDefaultProviders();
    }

    public void establishDataKeyListeners() {
        ((SpongeDataManager)this.game.getDataManager()).registerKeyListeners();
    }

    public void callRegisterDataPackValueEvent(Path datapackDir) {
        SpongeDataPackManager.INSTANCE.callRegisterDataPackValueEvents();
        try {
            SpongeDataPackManager.INSTANCE.serialize(datapackDir, new ArrayList<String>());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void callRegisterChannelEvent() {
        ((SpongeChannelRegistry)this.game.getChannelRegistry()).postRegistryEvent();
    }

    public void initTimings() {
        ((SpongeTimingsFactory)this.game.getFactoryProvider().provide(TimingsFactory.class)).init();
    }

    public void establishGameServices() {
        ((SpongeServiceProvider)((Object)this.game.getServiceProvider())).init();
    }

    public void establishServerServices() {
        ((MinecraftServerBridge)((Object)this.game.getServer())).bridge$initServices(this.game, this.injector);
    }

    public void establishServerFeatures() {
        ((SpongeServer)this.game.getServer()).getUsernameCache().load();
    }

    public SpongeCommandManager createCommandManager() {
        SpongeCommandManager result = (SpongeCommandManager)this.injector.getInstance(SpongeCommandManager.class);
        result.init();
        return result;
    }

    public void registerPluginListeners() {
        for (PluginContainer plugin : this.filterInternalPlugins(this.game.getPluginManager().getPlugins())) {
            this.game.getEventManager().registerListeners(plugin, plugin.getInstance());
        }
    }

    public void callConstructEvent() {
        for (PluginContainer plugin : this.filterInternalPlugins(this.game.getPluginManager().getPlugins())) {
            ((SpongeEventManager)this.game.getEventManager()).post((Event)SpongeEventFactory.createConstructPluginEvent(Cause.of(EventContext.empty(), this.game), this.game, plugin), plugin);
        }
    }

    public void establishServerRegistries(Server server) {
        SpongeRegistries.registerServerRegistries((SpongeRegistryHolder)server.registries());
        this.game.getEventManager().post(new AbstractRegisterRegistryEvent.EngineScopedImpl<Server>(Cause.of(EventContext.empty(), this.game), this.game, server));
        this.game.getEventManager().post(new AbstractRegisterRegistryValueEvent.EngineScopedImpl<Server>(Cause.of(EventContext.empty(), this.game), this.game, server));
    }

    public void establishClientRegistries(Client client) {
        this.game.getEventManager().post(new AbstractRegisterRegistryEvent.EngineScopedImpl<Client>(Cause.of(EventContext.empty(), this.game), this.game, client));
        this.game.getEventManager().post(new AbstractRegisterRegistryValueEvent.EngineScopedImpl<Client>(Cause.of(EventContext.empty(), this.game), this.game, client));
    }

    public void callStartingEngineEvent(Engine engine) {
        this.game.getEventManager().post(SpongeEventFactory.createStartingEngineEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), engine, this.game, TypeToken.get(engine.getClass())));
    }

    public void callStartedEngineEvent(Engine engine) {
        this.game.getEventManager().post(SpongeEventFactory.createStartedEngineEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), engine, this.game, TypeToken.get(engine.getClass())));
    }

    public void callLoadedGameEvent() {
        this.game.getEventManager().post(SpongeEventFactory.createLoadedGameEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), this.game));
    }

    public void callStoppingEngineEvent(Engine engine) {
        this.game.getEventManager().post(SpongeEventFactory.createStoppingEngineEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), engine, this.game, TypeToken.get(engine.getClass())));
    }

    private Collection<PluginContainer> filterInternalPlugins(Collection<PluginContainer> plugins) {
        return plugins.stream().filter(plugin -> !(plugin instanceof DummyPluginContainer)).collect(Collectors.toList());
    }
}

