/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.common.base.Preconditions;
import net.kyori.adventure.text.Component;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.api.advancement.AdvancementType;
import org.spongepowered.api.advancement.AdvancementTypes;
import org.spongepowered.api.advancement.DisplayInfo;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.adventure.SpongeAdventure;

public final class SpongeDisplayInfoBuilder
implements DisplayInfo.Builder {
    private AdvancementType advancementType;
    private Component description;
    private Component title;
    private ItemStackSnapshot icon;
    private boolean showToast;
    private boolean announceToChat;
    private boolean hidden;

    public SpongeDisplayInfoBuilder() {
        this.reset();
    }

    @Override
    public DisplayInfo.Builder type(AdvancementType advancementType) {
        Preconditions.checkNotNull((Object)advancementType, (Object)"advancementType");
        this.advancementType = advancementType;
        return this;
    }

    @Override
    public DisplayInfo.Builder description(Component description) {
        Preconditions.checkNotNull((Object)description, (Object)"description");
        this.description = description;
        return this;
    }

    @Override
    public DisplayInfo.Builder title(Component title) {
        Preconditions.checkNotNull((Object)title, (Object)"title");
        this.title = title;
        return this;
    }

    @Override
    public DisplayInfo.Builder icon(ItemStackSnapshot itemStackSnapshot) {
        Preconditions.checkNotNull((Object)itemStackSnapshot, (Object)"itemStackSnapshot");
        this.icon = itemStackSnapshot;
        return this;
    }

    @Override
    public DisplayInfo.Builder showToast(boolean showToast) {
        this.showToast = showToast;
        return this;
    }

    @Override
    public DisplayInfo.Builder announceToChat(boolean announceToChat) {
        this.announceToChat = announceToChat;
        return this;
    }

    @Override
    public DisplayInfo.Builder hidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    public org.spongepowered.api.advancement.DisplayInfo build() {
        Preconditions.checkState((this.title != null ? 1 : 0) != 0, (Object)"Title has not been set");
        Preconditions.checkState((this.icon != null ? 1 : 0) != 0, (Object)"Icon has not been set");
        ITextComponent title = SpongeAdventure.asVanilla(this.title);
        ITextComponent description = SpongeAdventure.asVanilla(this.description);
        FrameType frameType = (FrameType)this.advancementType;
        ItemStack icon = (ItemStack)this.icon.createStack();
        return (org.spongepowered.api.advancement.DisplayInfo)new DisplayInfo(icon, title, description, null, frameType, this.showToast, this.announceToChat, this.hidden);
    }

    @Override
    public DisplayInfo.Builder from(org.spongepowered.api.advancement.DisplayInfo value) {
        this.icon = value.getIcon();
        this.description = value.getDescription();
        this.advancementType = value.getType();
        this.announceToChat = value.doesAnnounceToChat();
        this.hidden = value.isHidden();
        this.showToast = value.doesShowToast();
        this.title = value.getTitle();
        return this;
    }

    @Override
    public DisplayInfo.Builder reset() {
        this.icon = null;
        this.description = Component.empty();
        this.advancementType = AdvancementTypes.TASK.get();
        this.announceToChat = true;
        this.hidden = false;
        this.showToast = true;
        this.title = null;
        return this;
    }
}

