/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.ban;

import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.Instant;
import java.util.Date;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.server.management.IPBanEntry;
import net.minecraft.server.management.IPBanList;
import net.minecraft.server.management.ProfileBanEntry;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.ban.Ban;
import org.spongepowered.api.service.ban.BanType;
import org.spongepowered.api.service.ban.BanTypes;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.management.IPBanListAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.profile.SpongeGameProfile;

public final class SpongeBanBuilder
implements Ban.Builder {
    private GameProfile profile;
    private InetAddress address;
    private BanType banType;
    @Nullable
    private Component reason;
    private Instant start = Instant.now();
    @Nullable
    private Instant end;
    @Nullable
    private Component source;

    @Override
    public Ban.Builder profile(GameProfile profile) {
        Preconditions.checkNotNull((Object)profile, (Object)"Profile cannot be null!");
        Preconditions.checkState((this.banType == BanTypes.PROFILE.get() ? 1 : 0) != 0, (Object)"Cannot set a GameProfile if the BanType is not BanTypes.PROFILE!");
        this.profile = profile;
        return this;
    }

    @Override
    public Ban.Builder address(InetAddress address) {
        Preconditions.checkNotNull((Object)address, (Object)"Address cannot be null!");
        Preconditions.checkState((this.banType == BanTypes.IP.get() ? 1 : 0) != 0, (Object)"Cannot set an InetAddress if the BanType is not BanTypes.IP!");
        this.address = address;
        return this;
    }

    @Override
    public Ban.Builder type(BanType type) {
        Preconditions.checkNotNull((Object)type, (Object)"BanType cannot be null!");
        if (type == BanTypes.IP.get()) {
            this.profile = null;
        } else {
            this.address = null;
        }
        this.banType = type;
        return this;
    }

    @Override
    public Ban.Builder reason(@Nullable Component reason) {
        this.reason = reason;
        return this;
    }

    @Override
    public Ban.Builder startDate(Instant instant) {
        Preconditions.checkNotNull((Object)instant, (Object)"Start date cannot be null!");
        this.start = instant;
        return this;
    }

    @Override
    public Ban.Builder expirationDate(@Nullable Instant instant) {
        this.end = instant;
        return this;
    }

    @Override
    public Ban.Builder source(@Nullable Component source) {
        this.source = source;
        return this;
    }

    @Override
    public Ban build() {
        String reason;
        Preconditions.checkState((this.banType != null ? 1 : 0) != 0, (Object)"BanType cannot be null!");
        String sourceName = this.source != null ? SpongeAdventure.legacySection(this.source) : null;
        String string = reason = this.reason != null ? SpongeAdventure.legacySection(this.reason) : null;
        if (this.banType == BanTypes.PROFILE.get()) {
            Preconditions.checkState((this.profile != null ? 1 : 0) != 0, (Object)"User cannot be null!");
            return (Ban)new ProfileBanEntry(SpongeGameProfile.toMcProfile(this.profile.withoutProperties()), Date.from(this.start), sourceName, this.toDate(this.end), reason);
        }
        Preconditions.checkState((this.address != null ? 1 : 0) != 0, (Object)"Address cannot be null!");
        IPBanList ipBans = SpongeCommon.getServer().func_184103_al().func_72363_f();
        return (Ban)new IPBanEntry(((IPBanListAccessor)ipBans).invoker$getIpFromAddress(new InetSocketAddress(this.address, 0)), Date.from(this.start), sourceName, this.toDate(this.end), reason);
    }

    private Date toDate(Instant instant) {
        return instant == null ? null : Date.from(instant);
    }

    @Override
    public Ban.Builder from(Ban ban) {
        this.reset();
        this.banType = ban.getType();
        if (this.banType.equals(BanTypes.PROFILE.get())) {
            this.profile = ((Ban.Profile)ban).getProfile();
        } else {
            this.address = ((Ban.IP)ban).getAddress();
        }
        this.reason = ban.getReason().orElse(null);
        this.start = ban.getCreationDate();
        this.end = ban.getExpirationDate().orElse(null);
        this.source = ban.getBanSource().orElse(null);
        return this;
    }

    @Override
    public Ban.Builder reset() {
        this.profile = null;
        this.address = null;
        this.banType = null;
        this.reason = null;
        this.start = Instant.now();
        this.end = null;
        this.source = null;
        return this;
    }
}

