/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.block.entity;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.block.entity.BlockEntityType;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.block.entity.SpongeBlockEntityArchetypeBuilder;
import org.spongepowered.common.data.AbstractArchetype;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.nbt.validation.RawDataValidator;
import org.spongepowered.common.data.nbt.validation.ValidationType;
import org.spongepowered.common.data.nbt.validation.ValidationTypes;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.data.provider.DataProviderLookup;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;

public final class SpongeBlockEntityArchetype
extends AbstractArchetype<BlockEntityType, BlockSnapshot, BlockEntity>
implements BlockEntityArchetype {
    final BlockState blockState;
    public static final ImmutableList<RawDataValidator> VALIDATORS = ImmutableList.of();
    private static final DataProviderLookup lookup = SpongeDataManager.getProviderRegistry().getProviderLookup(SpongeBlockEntityArchetype.class);

    SpongeBlockEntityArchetype(SpongeBlockEntityArchetypeBuilder builder) {
        super(builder.type, NBTTranslator.INSTANCE.translate(builder.data));
        this.blockState = builder.blockState;
    }

    @Override
    public BlockState getState() {
        return this.blockState;
    }

    @Override
    public BlockEntityType getBlockEntityType() {
        return (BlockEntityType)this.type;
    }

    @Override
    public DataContainer getBlockEntityData() {
        return NBTTranslator.INSTANCE.translateFrom(this.data);
    }

    @Override
    public Optional<BlockEntity> apply(ServerLocation location) {
        BlockState currentState = location.getBlock();
        Block currentBlock = ((net.minecraft.block.BlockState)currentState).func_177230_c();
        Block newBlock = ((net.minecraft.block.BlockState)this.blockState).func_177230_c();
        World minecraftWorld = (World)location.getWorld();
        BlockPos blockpos = VecHelper.toBlockPos(location);
        if (currentBlock != newBlock) {
            ((org.spongepowered.api.world.World)minecraftWorld).setBlock(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p(), this.blockState, BlockChangeFlags.ALL);
        }
        CompoundNBT compound = this.data.func_74737_b();
        @Nullable TileEntity tileEntity = minecraftWorld.func_175625_s(blockpos);
        if (tileEntity == null) {
            return Optional.empty();
        }
        compound.func_74768_a("x", blockpos.func_177958_n());
        compound.func_74768_a("y", blockpos.func_177956_o());
        compound.func_74768_a("z", blockpos.func_177952_p());
        tileEntity.func_230337_a_((net.minecraft.block.BlockState)currentState, compound);
        tileEntity.func_145836_u();
        return Optional.of((BlockEntity)tileEntity);
    }

    @Override
    public BlockSnapshot toSnapshot(ServerLocation location) {
        SpongeBlockSnapshotBuilder builder = SpongeBlockSnapshotBuilder.pooled();
        return builder.blockState(this.blockState).addUnsafeCompound(this.data.func_74737_b()).world(location.getWorldKey()).position(location.getBlockPosition()).build();
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Constants.Sponge.BlockEntityArchetype.BLOCK_ENTITY_TYPE, this.type).set(Constants.Sponge.BlockEntityArchetype.BLOCK_STATE, this.blockState).set(Constants.Sponge.BlockEntityArchetype.BLOCK_ENTITY_DATA, this.getBlockEntityData());
    }

    @Override
    public DataProviderLookup getLookup() {
        return lookup;
    }

    @Override
    protected ValidationType getValidationType() {
        return ValidationTypes.BLOCK_ENTITY.get();
    }

    @Override
    public BlockEntityArchetype copy() {
        SpongeBlockEntityArchetypeBuilder builder = new SpongeBlockEntityArchetypeBuilder();
        builder.type = (BlockEntityType)this.type;
        builder.data = NBTTranslator.INSTANCE.translate(this.data);
        builder.blockState = this.blockState;
        return builder.build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeBlockEntityArchetype that = (SpongeBlockEntityArchetype)o;
        return this.blockState.equals(that.blockState);
    }

    @Override
    protected ImmutableList<RawDataValidator> getValidators() {
        return VALIDATORS;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.blockState);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", this.type).add("state", (Object)this.blockState).add("data", (Object)this.data).toString();
    }
}

