/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.bridge.data;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataStore;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.util.Constants;

public interface CustomDataHolderBridge {
    public static void serializeCustomData(DataCompoundHolder object) {
        CompoundNBT compound = object.data$getCompound();
        if (!(object instanceof CustomDataHolderBridge)) {
            return;
        }
        DataManipulator.Mutable manipulator = ((CustomDataHolderBridge)((Object)object)).bridge$getManipulator();
        DataHolder dataHolder = (DataHolder)((Object)object);
        Class<?> dataHolderType = dataHolder.getClass();
        Set dataStores = manipulator.getKeys().stream().map(key -> SpongeDataManager.getDatastoreRegistry().getDataStore((Key<?>)key, (Type)dataHolderType)).collect(Collectors.toSet());
        DataContainer dataContainer = NBTTranslator.INSTANCE.translate(compound);
        dataContainer.remove(DataQuery.of("ForgeData", "SpongeData", "CustomManipulators"));
        if (!dataStores.isEmpty()) {
            for (DataStore dataStore : dataStores) {
                dataStore.serialize(manipulator, (DataView)dataContainer);
            }
        }
        CompoundNBT serialized = NBTTranslator.INSTANCE.translate(dataContainer);
        compound.func_197643_a(serialized);
        CompoundNBT spongeData = object.data$getSpongeData();
        List<DataView> failedData = ((CustomDataHolderBridge)((Object)object)).bridge$getFailedData();
        if (!failedData.isEmpty()) {
            ListNBT failedList = new ListNBT();
            for (DataView failedDatum : failedData) {
                failedList.add((Object)NBTTranslator.INSTANCE.translate(failedDatum));
            }
            spongeData.func_218657_a("FailedData", (INBT)failedList);
        } else {
            spongeData.func_82580_o("FailedData");
        }
    }

    public static void deserializeCustomData(DataCompoundHolder object) {
        CompoundNBT compound = object.data$getCompound();
        if (compound == null) {
            return;
        }
        if (!(object instanceof CustomDataHolderBridge) || !object.data$getSpongeData().func_150297_b("CustomManipulators", 9)) {
            return;
        }
        ListNBT list = object.data$getSpongeData().func_150295_c("CustomManipulators", 10);
        if (list.isEmpty()) {
            return;
        }
        DataContainer allData = NBTTranslator.INSTANCE.translate(compound);
        DataView spongeData = (DataView)allData.getView(Constants.Forge.ROOT).flatMap(forgeData -> forgeData.getView(Constants.Sponge.SPONGE_ROOT)).get();
        List updatedDataViews = spongeData.getViewList(Constants.Sponge.CUSTOM_MANIPULATOR_LIST).get().stream().map(CustomDataHolderBridge::updateDataViewForDataManipulator).collect(Collectors.toList());
        spongeData.set(Constants.Sponge.CUSTOM_MANIPULATOR_LIST, updatedDataViews);
        Class<DataHolder> typeToken = object.getClass().asSubclass(DataHolder.class);
        ArrayList dataStores = new ArrayList();
        ImmutableList.Builder failed = ImmutableList.builder();
        for (DataView dataView : updatedDataViews) {
            Optional dataStore = dataView.getString(Constants.Sponge.DATA_ID).flatMap(id -> ((SpongeDataManager)Sponge.getGame().getDataManager()).getDataStore(ResourceKey.resolve(id), typeToken));
            if (dataStore.isPresent()) {
                dataStores.add(dataStore.get());
                continue;
            }
            failed.add((Object)dataView);
        }
        for (DataStore dataStore : dataStores) {
            DataManipulator.Mutable manipulator = dataStore.deserialize(allData);
            ((CustomDataHolderBridge)((Object)object)).bridge$mergeDeserialized(manipulator);
        }
        ((CustomDataHolderBridge)((Object)object)).bridge$addFailedData((ImmutableList<DataView>)failed.build());
        CustomDataHolderBridge.syncCustomToTag(object);
    }

    public static void syncTagToCustom(Object dataHolder) {
        if (dataHolder instanceof DataCompoundHolder && ((DataCompoundHolder)dataHolder).data$hasSpongeData()) {
            DataCompoundHolder compoundHolder = (DataCompoundHolder)dataHolder;
            CompoundNBT compound = compoundHolder.data$getCompound();
            if (compound == null) {
                return;
            }
            CustomDataHolderBridge.deserializeCustomData((DataCompoundHolder)dataHolder);
        }
    }

    public static void syncCustomToTag(Object dataHolder) {
        if (dataHolder instanceof DataCompoundHolder) {
            DataCompoundHolder compoundHolder = (DataCompoundHolder)dataHolder;
            CompoundNBT compound = compoundHolder.data$getCompound();
            if (compound == null) {
                compound = new CompoundNBT();
                compoundHolder.data$setCompound(compound);
            }
            CustomDataHolderBridge.serializeCustomData((DataCompoundHolder)dataHolder);
            compoundHolder.data$cleanEmptySpongeData();
        }
    }

    public void bridge$mergeDeserialized(DataManipulator.Mutable var1);

    public static DataView updateDataViewForDataManipulator(DataView dataView) {
        int version = dataView.getInt(Queries.CONTENT_VERSION).orElse(1);
        if (version != 2) {
            DataContentUpdater contentUpdater = ((SpongeDataManager)Sponge.getGame().getDataManager()).getWrappedCustomContentUpdater(DataManipulator.Mutable.class, version, 2).orElseThrow(() -> new IllegalArgumentException("Could not find a content updater for DataManipulator information with version: " + version));
            return contentUpdater.update(dataView);
        }
        return dataView;
    }

    public void bridge$clearCustomData();

    default public <E> Optional<E> bridge$getCustom(Key<? extends Value<E>> key) {
        return this.bridge$getManipulator().get(key);
    }

    default public <E> DataTransactionResult bridge$offerCustom(Key<? extends Value<E>> key, E value) {
        DataManipulator.Mutable manipulator = this.bridge$getManipulator();
        Value.Immutable immutableValue = manipulator.getValue(key).map(Value::asImmutable).orElse(null);
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        if (immutableValue != null) {
            builder.replace(immutableValue);
        }
        manipulator.set(key, value);
        builder.success(manipulator.getValue(key).get().asImmutable());
        CustomDataHolderBridge.syncCustomToTag(this);
        return builder.result(DataTransactionResult.Type.SUCCESS).build();
    }

    default public <E> DataTransactionResult bridge$removeCustom(Key<? extends Value<E>> key) {
        DataManipulator.Mutable manipulator = this.bridge$getManipulator();
        Optional<Value<E>> value = manipulator.getValue(key);
        if (value.isPresent()) {
            manipulator.remove(key);
        }
        CustomDataHolderBridge.syncCustomToTag(this);
        return value.map(Value::asImmutable).map(DataTransactionResult::successRemove).orElseGet(DataTransactionResult::successNoData);
    }

    public DataManipulator.Mutable bridge$getManipulator();

    default public void bridge$addFailedData(ImmutableList<DataView> failedData) {
        this.bridge$getFailedData().addAll((Collection<DataView>)failedData);
    }

    public List<DataView> bridge$getFailedData();
}

