/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.ArgumentReader;

public final class SpongeImmutableArgumentReader
implements ArgumentReader.Immutable,
ImmutableStringReader {
    private final String input;
    private final int cursor;
    private final int length;
    private final int remaining;

    SpongeImmutableArgumentReader(String input, int cursor) {
        this.input = input;
        this.cursor = cursor;
        this.length = this.input.length();
        this.remaining = this.length - cursor;
    }

    public String getString() {
        return this.input;
    }

    @Override
    public @NonNull String getInput() {
        return this.input;
    }

    @Override
    public int getRemainingLength() {
        return this.remaining;
    }

    @Override
    public int getTotalLength() {
        return this.length;
    }

    @Override
    public int getCursor() {
        return this.cursor;
    }

    @Override
    public @NonNull String getRead() {
        if (this.cursor == 0) {
            return "";
        }
        return this.input.substring(0, this.cursor);
    }

    @Override
    public @NonNull String getRemaining() {
        return this.input.substring(this.cursor);
    }

    public boolean canRead(int length) {
        return this.cursor + length <= this.length;
    }

    @Override
    public boolean canRead() {
        return this.canRead(1);
    }

    @Override
    public char peekCharacter() {
        if (this.canRead()) {
            return this.input.charAt(this.cursor);
        }
        throw new IllegalStateException("Cannot read past the end of a string!");
    }

    @Override
    public @NonNull ArgumentParseException createException(@NonNull Component errorMessage) {
        return new ArgumentParseException(errorMessage, this.getInput(), this.getCursor());
    }

    public char peek() {
        return this.peek(0);
    }

    public char peek(int offset) {
        return this.input.charAt(this.cursor + offset);
    }

    @Override
    public  @NonNull ArgumentReader.Mutable getMutable() {
        StringReader reader = new StringReader(this.input);
        reader.setCursor(this.cursor);
        return (ArgumentReader.Mutable)reader;
    }
}

