/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.brigadier.tree;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.SuggestionProviders;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.ValueCompleter;
import org.spongepowered.api.command.parameter.managed.ValueUsage;
import org.spongepowered.common.bridge.command.arguments.CompletionsArgumentTypeBridge;
import org.spongepowered.common.command.brigadier.SpongeStringReader;
import org.spongepowered.common.command.brigadier.argument.ArgumentParser;
import org.spongepowered.common.command.brigadier.argument.ComplexSuggestionNodeProvider;
import org.spongepowered.common.command.brigadier.context.SpongeCommandContextBuilder;
import org.spongepowered.common.command.brigadier.tree.SpongeNode;
import org.spongepowered.common.command.brigadier.tree.UnsortedNodeHolder;
import org.spongepowered.common.util.CommandUtil;
import org.spongepowered.common.util.Constants;

public final class SpongeArgumentCommandNode<T>
extends ArgumentCommandNode<CommandSource, T>
implements SpongeNode {
    private final Parameter.Key<? super T> key;
    private final ArgumentParser<? extends T> parser;
    private final ValueUsage usage;
    private final boolean isComplexSuggestions;
    private final UnsortedNodeHolder nodeHolder = new UnsortedNodeHolder();
    private @Nullable Command<CommandSource> executor;
    private @Nullable CommandNode<CommandSource> forcedRedirect;

    private static @Nullable SuggestionProvider<CommandSource> createSuggestionProvider(@Nullable ValueCompleter completer) {
        if (completer == null) {
            return null;
        }
        return (context, builder) -> {
            List<String> suggestions = completer.complete((org.spongepowered.api.command.parameter.CommandContext)context, builder.getRemaining());
            for (String suggestion : suggestions) {
                builder.suggest(suggestion);
            }
            return builder.buildFuture();
        };
    }

    public SpongeArgumentCommandNode(Parameter.Key<? super T> key, ValueUsage usage, ArgumentParser<? extends T> parser, @Nullable ValueCompleter valueCompleter, @Nullable Command command, Predicate<CommandSource> predicate, @Nullable CommandNode<CommandSource> redirect, RedirectModifier<CommandSource> modifier, boolean forks, String keyName) {
        super(keyName, Constants.Command.STANDARD_STRING_ARGUMENT_TYPE, command, predicate, redirect, modifier, forks, SpongeArgumentCommandNode.createSuggestionProvider(valueCompleter));
        this.parser = parser;
        this.isComplexSuggestions = this.parser instanceof ComplexSuggestionNodeProvider;
        this.key = key;
        this.usage = usage;
    }

    public final boolean isComplex() {
        return this.isComplexSuggestions;
    }

    public final CommandNode<ISuggestionProvider> getComplexSuggestions(CommandNode<ISuggestionProvider> rootSuggestionNode, Map<CommandNode<CommandSource>, CommandNode<ISuggestionProvider>> commandNodeToSuggestionNode, Map<CommandNode<CommandSource>, List<CommandNode<ISuggestionProvider>>> commandNodeListMap, boolean allowCustomSuggestionsOnTheFirstElement) {
        if (!this.isComplexSuggestions) {
            throw new IllegalStateException("The parser is not a ComplexSuggestionNodeParser");
        }
        ComplexSuggestionNodeProvider provider = (ComplexSuggestionNodeProvider)((Object)this.parser);
        return provider.createSuggestions(rootSuggestionNode, this.key.key(), this.getCommand() != null, nodeList -> commandNodeListMap.put((CommandNode<CommandSource>)this, (List<CommandNode<ISuggestionProvider>>)nodeList), firstNode -> commandNodeToSuggestionNode.put((CommandNode<CommandSource>)this, (CommandNode<ISuggestionProvider>)firstNode), allowCustomSuggestionsOnTheFirstElement);
    }

    @Override
    public final Collection<CommandNode<CommandSource>> getChildrenForSuggestions() {
        return this.nodeHolder.getChildrenForSuggestions();
    }

    private ArgumentType<?> switchTypeIfRequired(ArgumentType<?> type) {
        if (type instanceof CompletionsArgumentTypeBridge) {
            return ((CompletionsArgumentTypeBridge)type).bridge$clientSideCompletionType();
        }
        return type;
    }

    public final ArgumentBuilder<ISuggestionProvider, ?> createBuilderForSuggestions(CommandNode<ISuggestionProvider> rootSuggestionNode, Map<CommandNode<CommandSource>, CommandNode<ISuggestionProvider>> commandNodeToSuggestionNode) {
        ArgumentType<?> type = this.switchTypeIfRequired(this.getType());
        ArgumentCommandNode previousNode = rootSuggestionNode;
        if (!this.parser.getClientCompletionArgumentType().isEmpty()) {
            boolean forceCustomSuggestions;
            Collection types = this.parser.getClientCompletionArgumentType().stream().filter(Objects::nonNull).collect(Collectors.toList());
            if (types.size() > 1) {
                forceCustomSuggestions = false;
                Iterator<ArgumentType<?>> clientCompletionTypeIterator = this.parser.getClientCompletionArgumentType().iterator();
                boolean isFirst = true;
                while (clientCompletionTypeIterator.hasNext()) {
                    boolean forceCustomSuggestionsInner;
                    ArgumentType<?> originalType = clientCompletionTypeIterator.next();
                    type = this.switchTypeIfRequired(originalType);
                    boolean bl = forceCustomSuggestionsInner = type != this.getType() && !CommandUtil.checkForCustomSuggestions(previousNode);
                    if (!clientCompletionTypeIterator.hasNext()) continue;
                    RequiredArgumentBuilder arg = RequiredArgumentBuilder.argument((String)this.getName(), type);
                    arg.requires(x -> true);
                    if (isFirst && type instanceof StringArgumentType) {
                        arg.suggests(this.parser::listSuggestions);
                    }
                    if (forceCustomSuggestionsInner) {
                        arg.suggests(SuggestionProviders.field_197502_a);
                    }
                    ArgumentCommandNode built = arg.build();
                    previousNode.addChild((CommandNode)built);
                    previousNode = built;
                    if (!isFirst) continue;
                    commandNodeToSuggestionNode.put((CommandNode<CommandSource>)this, (CommandNode<ISuggestionProvider>)built);
                    isFirst = false;
                }
            } else {
                ArgumentType<?> originalType = this.parser.getClientCompletionArgumentType().get(0);
                type = this.switchTypeIfRequired(originalType);
                forceCustomSuggestions = type != originalType;
            }
            RequiredArgumentBuilder toReturn = RequiredArgumentBuilder.argument((String)this.getUsageTextForClient(), type);
            if (this.getCommand() != null) {
                toReturn.executes(x -> 0);
            }
            if (forceCustomSuggestions && !CommandUtil.checkForCustomSuggestions(previousNode)) {
                toReturn.suggests(SuggestionProviders.field_197502_a);
            } else if (this.getCustomSuggestions() != null) {
                toReturn.suggests(this.getCustomSuggestions());
            }
            if (this.getRedirect() != null) {
                toReturn.forward(this.getRedirect(), this.getRedirectModifier(), this.isFork());
            }
            return toReturn;
        }
        RequiredArgumentBuilder builder = RequiredArgumentBuilder.argument((String)this.getUsageTextForClient(), type);
        builder.requires(this.getRequirement());
        builder.forward(this.getRedirect(), this.getRedirectModifier(), this.isFork());
        if (!CommandUtil.checkForCustomSuggestions(rootSuggestionNode)) {
            if (type != this.getType()) {
                builder.suggests(SuggestionProviders.field_197502_a);
            } else {
                builder.suggests(this.getCustomSuggestions());
            }
        }
        if (this.getCommand() != null) {
            builder.executes(this.getCommand());
        }
        return builder;
    }

    public final ArgumentParser<? extends T> getParser() {
        return this.parser;
    }

    @Override
    public void forceExecutor(Command<CommandSource> forcedExecutor) {
        this.executor = forcedExecutor;
    }

    @Override
    public boolean canForceRedirect() {
        return this.getChildren() == null || this.getChildren().isEmpty();
    }

    @Override
    public void forceRedirect(CommandNode<CommandSource> forcedRedirect) {
        this.forcedRedirect = forcedRedirect;
    }

    public CommandNode<CommandSource> getRedirect() {
        CommandNode redirect = super.getRedirect();
        if (redirect != null) {
            return redirect;
        }
        if (this.canForceRedirect()) {
            return this.forcedRedirect;
        }
        return null;
    }

    public Command<CommandSource> getCommand() {
        Command command = super.getCommand();
        if (command != null) {
            return command;
        }
        return this.executor;
    }

    public String getUsageText() {
        if (this.usage != null) {
            return this.usage.getUsage(this.key.key());
        }
        return super.getUsageText();
    }

    private String getUsageTextForClient() {
        if (this.usage != null) {
            return this.usage.getUsage(this.key.key());
        }
        return this.getName();
    }

    public final void parse(StringReader reader, CommandContextBuilder<CommandSource> contextBuilder) throws CommandSyntaxException {
        int start = reader.getCursor();
        SpongeCommandContextBuilder builder = (SpongeCommandContextBuilder)contextBuilder;
        T result = this.parser.parse(this.key, builder, (SpongeStringReader)reader);
        if (result != null) {
            builder.putEntry(this.key, result);
            ParsedArgument parsed = new ParsedArgument(start, reader.getCursor(), result);
            builder.withArgumentInternal(this.getName(), parsed, false);
            builder.withNode((CommandNode<CommandSource>)this, parsed.getRange());
        } else if (this.parser.doesNotRead()) {
            builder.withNode((CommandNode<CommandSource>)this, StringRange.at((int)start));
        }
    }

    public final CompletableFuture<Suggestions> listSuggestions(CommandContext<CommandSource> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        if (this.getCustomSuggestions() == null) {
            return this.parser.listSuggestions(context, builder);
        }
        return this.getCustomSuggestions().getSuggestions(context, builder);
    }

    public final Collection<String> getExamples() {
        return this.parser.getExamples();
    }

    public void addChild(CommandNode<CommandSource> node) {
        super.addChild(node);
        this.nodeHolder.add(node);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.key, this.parser, this.usage, this.isComplexSuggestions, this.getCustomSuggestions());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeArgumentCommandNode that = (SpongeArgumentCommandNode)o;
        return this.isComplexSuggestions == that.isComplexSuggestions && this.getRedirect() == that.getRedirect() && this.key.equals(that.key) && this.parser.equals(that.parser) && Objects.equals(this.usage, that.usage) && Objects.equals(this.getCustomSuggestions(), that.getCustomSuggestions());
    }
}

