/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.standard;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.minecraft.command.arguments.ColorArgument;
import net.minecraft.util.text.TextFormatting;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.api.util.Color;
import org.spongepowered.common.accessor.util.text.TextFormattingAccessor;
import org.spongepowered.common.command.brigadier.argument.ResourceKeyedArgumentValueParser;

public final class SpongeColorValueParameter
extends ResourceKeyedArgumentValueParser<Color> {
    private static final Pattern HEX_CODE = Pattern.compile("#[0-9A-Fa-f]{6}");
    private final ColorArgument colorArgumentType = ColorArgument.func_197063_a();

    public SpongeColorValueParameter(ResourceKey key) {
        super(key);
    }

    @Override
    public CompletableFuture<Suggestions> listSuggestions(CommandContext<?> context, SuggestionsBuilder builder) {
        return this.colorArgumentType.listSuggestions(context, builder);
    }

    @Override
    public @NonNull List<String> complete(@NonNull org.spongepowered.api.command.parameter.CommandContext context, String currentInput) {
        SuggestionsBuilder builder = new SuggestionsBuilder(currentInput, 0);
        this.listSuggestions((CommandContext)context, builder);
        return builder.build().getList().stream().map(Suggestion::getText).collect(Collectors.toList());
    }

    @Override
    public @NonNull Optional<? extends Color> getValue( @NonNull Parameter.Key<? super Color> parameterKey,  @NonNull ArgumentReader.Mutable reader,  @NonNull CommandContext.Builder context) throws ArgumentParseException {
        String[] rgb;
        ArgumentReader.Immutable state = reader.getImmutable();
        try {
            TextFormatting formatting = this.colorArgumentType.parse((StringReader)reader);
            Integer colorCode = ((TextFormattingAccessor)formatting).accessor$color();
            if (colorCode != null) {
                return Optional.of(Color.ofRgb(colorCode));
            }
        }
        catch (CommandSyntaxException formatting) {
            // empty catch block
        }
        reader.setState(state);
        String string = reader.parseUnquotedString();
        if (HEX_CODE.matcher(string).matches()) {
            try {
                return Optional.of(Color.ofRgb(Integer.parseInt(string.substring(1), 16)));
            }
            catch (NumberFormatException colorCode) {
                // empty catch block
            }
        }
        if ((rgb = string.split(",", 3)).length == 3) {
            try {
                return Optional.of(Color.ofRgb(this.checkIntConversion(rgb[0]), this.checkIntConversion(rgb[1]), this.checkIntConversion(rgb[2])));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw reader.createException((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("The color is not in one of the expected formats:").append((Component)Component.newline())).append((Component)Component.text((String)"* Named color (such as \"black\")"))).append((Component)Component.newline())).append((Component)Component.text((String)"* Hex encoded color, starting with # (such as \"#000000\")"))).append((Component)Component.newline())).append((Component)Component.text((String)"* Comma separated RGB color, with values from 0 to 255 (such as \"0,128,255\")"))).build());
    }

    private int checkIntConversion(String entry) {
        int i;
        try {
            i = Integer.parseInt(entry);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
        if (i > 255 || i < 0) {
            throw new IllegalArgumentException();
        }
        return i;
    }
}

