/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.standard;

import com.google.common.collect.ImmutableList;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.common.command.brigadier.argument.ResourceKeyedArgumentValueParser;

public final class SpongeDateTimeValueParameter
extends ResourceKeyedArgumentValueParser<LocalDateTime> {
    public SpongeDateTimeValueParameter(ResourceKey key) {
        super(key);
    }

    @Override
    public @NonNull List<String> complete(@NonNull CommandContext context, String currentInput) {
        return ImmutableList.of();
    }

    @Override
    public @NonNull Optional<? extends LocalDateTime> getValue( @NonNull Parameter.Key<? super LocalDateTime> parameterKey,  @NonNull ArgumentReader.Mutable reader, @NonNull CommandContext.Builder context) throws ArgumentParseException {
        String date = reader.parseString();
        try {
            return Optional.of(LocalDateTime.parse(date));
        }
        catch (DateTimeParseException ex) {
            try {
                return Optional.of(LocalDateTime.of(LocalDate.now(), LocalTime.parse(date)));
            }
            catch (DateTimeParseException ex2) {
                try {
                    return Optional.of(LocalDateTime.of(LocalDate.parse(date), LocalTime.MIDNIGHT));
                }
                catch (DateTimeParseException ex3) {
                    throw reader.createException((Component)Component.text((String)"Invalid date-time!"));
                }
            }
        }
    }
}

