/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.standard;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.arguments.ArgumentType;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.common.command.brigadier.argument.AbstractArgumentParser;
import org.spongepowered.common.util.Constants;

public final class SpongeTextValueParameter
extends AbstractArgumentParser<Component> {
    private final ComponentSerializer<Component, ? extends Component, String> textSerializer;
    private final boolean consumeAll;
    private final ArgumentType<?> clientCompletionType;

    public SpongeTextValueParameter(ComponentSerializer<Component, ? extends Component, String> textSerializer, boolean consumeAll) {
        this.textSerializer = textSerializer;
        this.consumeAll = consumeAll;
        this.clientCompletionType = this.consumeAll ? Constants.Command.GREEDY_STRING_ARGUMENT_TYPE : (this.textSerializer instanceof GsonComponentSerializer ? Constants.Command.NBT_ARGUMENT_TYPE : Constants.Command.STANDARD_STRING_ARGUMENT_TYPE);
    }

    @Override
    public @NonNull List<String> complete(@NonNull CommandContext context, String currentInput) {
        return ImmutableList.of();
    }

    @Override
    public @NonNull Optional<? extends Component> getValue( @NonNull Parameter.Key<? super Component> parameterKey,  @NonNull ArgumentReader.Mutable reader, @NonNull CommandContext.Builder context) throws ArgumentParseException {
        String toConvert;
        if (this.consumeAll) {
            toConvert = reader.getRemaining();
            while (reader.canRead()) {
                reader.parseString();
            }
        } else {
            toConvert = reader.parseString();
        }
        return Optional.of(this.textSerializer.deserialize((Object)toConvert));
    }

    @Override
    public List<ArgumentType<?>> getClientCompletionArgumentType() {
        return ImmutableList.of(this.clientCompletionType);
    }
}

