/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.registrar;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.minecraft.command.CommandSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.api.command.manager.CommandFailedRegistrationException;
import org.spongepowered.api.command.manager.CommandManager;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.api.command.registrar.CommandRegistrar;
import org.spongepowered.api.command.registrar.CommandRegistrarType;
import org.spongepowered.common.command.SpongeParameterizedCommand;
import org.spongepowered.common.command.brigadier.dispatcher.SpongeCommandDispatcher;
import org.spongepowered.common.command.exception.SpongeCommandSyntaxException;
import org.spongepowered.common.command.manager.SpongeCommandManager;
import org.spongepowered.common.command.registrar.BrigadierBasedRegistrar;
import org.spongepowered.common.command.registrar.SpongeCommandRegistrarType;
import org.spongepowered.plugin.PluginContainer;

public final class SpongeParameterizedCommandRegistrar
implements BrigadierBasedRegistrar,
CommandRegistrar<Command.Parameterized> {
    public static final CommandRegistrarType<Command.Parameterized> TYPE = new SpongeCommandRegistrarType<Command.Parameterized>(Command.Parameterized.class, SpongeParameterizedCommandRegistrar::new);
    private final CommandManager.Mutable commandManager;
    private final Map<CommandMapping, Command.Parameterized> commandMap = new HashMap<CommandMapping, Command.Parameterized>();

    public SpongeParameterizedCommandRegistrar(CommandManager.Mutable commandManager) {
        this.commandManager = commandManager;
    }

    @Override
    public @NonNull CommandRegistrarType<Command.Parameterized> type() {
        return TYPE;
    }

    private SpongeCommandManager commandManager() {
        return (SpongeCommandManager)this.commandManager;
    }

    @Override
    public @NonNull CommandMapping register(@NonNull PluginContainer container,  @NonNull Command.Parameterized command, @NonNull String primaryAlias, String ... secondaryAliases) throws CommandFailedRegistrationException {
        String namespacedCommand = container.getMetadata().getId() + ":" + primaryAlias.toLowerCase(Locale.ROOT);
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.add(primaryAlias);
        aliases.addAll(Arrays.asList(secondaryAliases));
        CommandMapping mapping = this.commandManager().registerAliasWithNamespacing(this, container, namespacedCommand, aliases, null);
        this.createNode(mapping, command).forEach(this.commandManager().getDispatcher()::register);
        ((SpongeParameterizedCommand)command).setCommandManager(this.commandManager());
        this.commandMap.put(mapping, command);
        return mapping;
    }

    @Override
    public @NonNull CommandResult process(@NonNull CommandCause cause, @NonNull CommandMapping mapping, @NonNull String command, @NonNull String arguments) throws CommandException {
        try {
            SpongeCommandDispatcher dispatcher = this.commandManager().getDispatcher();
            return CommandResult.builder().setResult(dispatcher.execute(dispatcher.parse(this.createCommandString(command, arguments), (CommandSource)cause))).build();
        }
        catch (SpongeCommandSyntaxException ex) {
            throw ex.getCause();
        }
        catch (CommandSyntaxException e) {
            throw new CommandException((Component)Component.text((String)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public @NonNull List<String> suggestions(@NonNull CommandCause cause, @NonNull CommandMapping mapping, @NonNull String command, @NonNull String arguments) {
        try {
            SpongeCommandDispatcher dispatcher = this.commandManager().getDispatcher();
            return ((Suggestions)dispatcher.getCompletionSuggestions(dispatcher.parse(this.createCommandString(command, arguments), (CommandSource)cause)).join()).getList().stream().map(Suggestion::getText).collect(Collectors.toList());
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    @Override
    public @NonNull Optional<Component> help(@NonNull CommandCause cause, @NonNull CommandMapping command) {
        Command.Parameterized commandEntry = this.commandMap.get(command);
        if (commandEntry == null) {
            throw new IllegalArgumentException(command + " is not a valid a valid command!");
        }
        return commandEntry.getHelp(cause);
    }

    @Override
    public boolean canExecute(@NonNull CommandCause cause, @NonNull CommandMapping mapping) {
        return this.commandMap.get(mapping).canExecute(cause);
    }

    private String createCommandString(String command, String argument) {
        if (argument.isEmpty()) {
            return command;
        }
        return command + " " + argument;
    }

    private Collection<LiteralCommandNode<CommandSource>> createNode(CommandMapping mapping, Command.Parameterized command) {
        if (!(command instanceof SpongeParameterizedCommand)) {
            throw new IllegalArgumentException("Command must be a SpongeParameterizedCommand!");
        }
        return ((SpongeParameterizedCommand)command).buildWithAliases(mapping.getAllAliases());
    }
}

