/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.sponge;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.api.command.parameter.managed.clientcompletion.ClientCompletionType;
import org.spongepowered.api.command.parameter.managed.clientcompletion.ClientCompletionTypes;

public final class CommandAliasesParameter
implements ValueParameter<CommandMapping> {
    @Override
    public List<String> complete(CommandContext context, String input) {
        return Sponge.getGame().getServer().getCommandManager().getKnownAliases().stream().filter(x -> x.startsWith(input)).collect(Collectors.toList());
    }

    @Override
    public Optional<? extends CommandMapping> getValue(Parameter.Key<? super CommandMapping> parameterKey, ArgumentReader.Mutable reader, CommandContext.Builder context) throws ArgumentParseException {
        Optional<CommandMapping> mapping;
        String alias = reader.parseString().toLowerCase(Locale.ROOT);
        if (reader.canRead() && reader.peekCharacter() == ':') {
            alias = alias + reader.parseChar() + reader.parseUnquotedString();
        }
        if ((mapping = Sponge.getGame().getServer().getCommandManager().getCommandMapping(alias)).isPresent()) {
            return mapping;
        }
        throw reader.createException((Component)Component.text((String)("A command with alias " + alias + " does not exist.")));
    }

    @Override
    public List<ClientCompletionType> getClientCompletionType() {
        return Collections.singletonList(ClientCompletionTypes.RESOURCE_KEY.get());
    }
}

