/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.sponge;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.launch.plugin.DummyPluginContainer;
import org.spongepowered.plugin.PluginContainer;

public final class FilteredPluginContainerParameter
implements ValueParameter<PluginContainer> {
    private final Map<String, PluginContainer> validPluginContainers = FilteredPluginContainerParameter.getValidContainers();

    private static Map<String, PluginContainer> getValidContainers() {
        return ((Launch)Launch.getInstance()).getPluginManager().getPlugins().stream().filter(x -> !(x instanceof DummyPluginContainer)).collect(Collectors.toMap(x -> x.getMetadata().getId(), x -> x));
    }

    @Override
    public List<String> complete(CommandContext context, String currentInput) {
        return ImmutableList.copyOf(this.validPluginContainers.keySet());
    }

    @Override
    public Optional<? extends PluginContainer> getValue(Parameter.Key<? super PluginContainer> parameterKey, ArgumentReader.Mutable reader, CommandContext.Builder context) throws ArgumentParseException {
        String id = reader.parseString();
        PluginContainer pluginContainer = this.validPluginContainers.get(id);
        if (pluginContainer != null) {
            return Optional.of(pluginContainer);
        }
        throw reader.createException((Component)Component.text((String)("Could not find valid plugin to refresh with ID \"" + id + "\"")));
    }
}

