/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.tracker;

import java.util.HashMap;
import java.util.Map;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;

@ConfigSerializable
public final class EntityTrackerCategory {
    @Setting(value="auto-populate")
    @Comment(value="If 'true', newly discovered entities will be added to this config with default settings.")
    public boolean autoPopulate = false;
    @Setting
    @Comment(value="Per-mod entity id mappings for controlling tracking behavior")
    public final Map<String, EntityTrackerModCategory> mods = new HashMap<String, EntityTrackerModCategory>();

    public EntityTrackerCategory() {
        this.mods.put("minecraft", new EntityTrackerModCategory("minecraft"));
    }

    @ConfigSerializable
    public static final class EntityTrackerModCategory {
        @Setting
        @Comment(value="If 'false', all tracking for this mod will be ignored.")
        public boolean enabled = true;
        @Setting(value="block-bulk-capture")
        @Comment(value="Set to true to perform block bulk capturing during entity ticks. (Default: true)")
        public final Map<String, Boolean> blockBulkCapture = new HashMap<String, Boolean>();
        @Setting(value="block-event-creation")
        @Comment(value="Set to true to create and fire block events during entity ticks. (Default: true)")
        public final Map<String, Boolean> blockEventCreation = new HashMap<String, Boolean>();
        @Setting(value="entity-bulk-capture")
        @Comment(value="Set to true to perform entity bulk capturing during entity ticks. (Default: true)")
        public final Map<String, Boolean> entityBulkCapture = new HashMap<String, Boolean>();
        @Setting(value="entity-block-creation")
        @Comment(value="Set to true to create and fire entity events during entity ticks. (Default: true)")
        public final Map<String, Boolean> entityEventCreation = new HashMap<String, Boolean>();

        public EntityTrackerModCategory() {
        }

        public EntityTrackerModCategory(String name) {
            if (name.equals("minecraft")) {
                this.blockBulkCapture.put("item", false);
                this.blockBulkCapture.put("experience_orb", false);
                this.blockBulkCapture.put("leash_hitch", false);
                this.blockBulkCapture.put("painting", false);
                this.blockBulkCapture.put("armor_stand", false);
                this.blockBulkCapture.put("llama_spit", false);
            }
        }
    }
}

