/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import com.google.common.collect.Multimap;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataProvider;
import org.spongepowered.api.data.DataRegistration;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.UnregisteredKeyException;
import org.spongepowered.api.data.persistence.DataStore;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.data.SpongeDataRegistrationBuilder;

public final class SpongeDataRegistration
implements DataRegistration {
    final List<Key<?>> keys;
    final Map<Type, DataStore> dataStoreMap;
    final Multimap<Key, DataProvider> dataProviderMap;

    SpongeDataRegistration(SpongeDataRegistrationBuilder builder) {
        this.keys = builder.keys;
        this.dataStoreMap = builder.dataStoreMap;
        this.dataProviderMap = builder.dataProviderMap;
    }

    @Override
    public <V extends Value<E>, E> Collection<DataProvider<V, E>> getProvidersFor(Key<V> key) throws UnregisteredKeyException {
        return this.dataProviderMap.get(key);
    }

    @Override
    public Optional<DataStore> getDataStore(TypeToken<? extends DataHolder> token) {
        return this.getDataStore0(token.getType());
    }

    @Override
    public Optional<DataStore> getDataStore(Class<? extends DataHolder> token) {
        return this.getDataStore0(token);
    }

    private Optional<DataStore> getDataStore0(Type type) {
        DataStore dataStore = this.dataStoreMap.get(type);
        if (dataStore != null) {
            return Optional.of(dataStore);
        }
        for (Map.Entry<Type, DataStore> entry : this.dataStoreMap.entrySet()) {
            if (!GenericTypeReflector.isSuperType(entry.getKey(), type)) continue;
            dataStore = entry.getValue();
            this.dataStoreMap.put(type, dataStore);
            return Optional.of(dataStore);
        }
        return Optional.empty();
    }

    @Override
    public Iterable<Key<?>> getKeys() {
        return this.keys;
    }

    public Collection<DataStore> getDataStores() {
        return this.dataStoreMap.values();
    }

    public Collection<DataProvider> getDataProviders() {
        return this.dataProviderMap.values();
    }
}

