/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.item;

import java.util.List;
import java.util.Optional;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.item.FireworkEffect;
import org.spongepowered.api.item.FireworkShape;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.util.Color;
import org.spongepowered.common.util.Constants;

public final class SpongeFireworkEffectDataBuilder
extends AbstractDataBuilder<FireworkEffect>
implements DataBuilder<FireworkEffect> {
    private static final int SUPPORTED_VERSION = 1;

    public SpongeFireworkEffectDataBuilder() {
        super(FireworkEffect.class, 1);
    }

    @Override
    protected Optional<FireworkEffect> buildContent(DataView container) throws InvalidDataException {
        if (container.contains(Constants.Item.Fireworks.FIREWORK_SHAPE, Constants.Item.Fireworks.FIREWORK_COLORS, Constants.Item.Fireworks.FIREWORK_FADE_COLORS, Constants.Item.Fireworks.FIREWORK_FLICKERS, Constants.Item.Fireworks.FIREWORK_TRAILS)) {
            ResourceKey key = container.getResourceKey(Constants.Item.Fireworks.FIREWORK_SHAPE).get();
            Optional shapeOptional = Sponge.getGame().registries().registry(RegistryTypes.FIREWORK_SHAPE).findValue(key);
            if (!shapeOptional.isPresent()) {
                throw new InvalidDataException("Could not find the FireworkShape for the provided id: " + key);
            }
            FireworkShape shape = (FireworkShape)shapeOptional.get();
            boolean trails = container.getBoolean(Constants.Item.Fireworks.FIREWORK_TRAILS).get();
            boolean flickers = container.getBoolean(Constants.Item.Fireworks.FIREWORK_FLICKERS).get();
            List<Color> colors = container.getSerializableList(Constants.Item.Fireworks.FIREWORK_COLORS, Color.class).get();
            List<Color> fadeColors = container.getSerializableList(Constants.Item.Fireworks.FIREWORK_FADE_COLORS, Color.class).get();
            return Optional.of(FireworkEffect.builder().colors(colors).flicker(flickers).fades(fadeColors).trail(trails).shape(shape).build());
        }
        return Optional.empty();
    }
}

