/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.datasync.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.accessor.entity.MobEntityAccessor;
import org.spongepowered.common.data.datasync.DataParameterConverter;

public final class MobEntityAIFlagsConverter
extends DataParameterConverter<Byte> {
    public MobEntityAIFlagsConverter() {
        super(MobEntityAccessor.accessor$DATA_MOB_FLAGS_ID());
    }

    @Override
    public Optional<DataTransactionResult> createTransaction(Entity entity, Byte currentValue, Byte value) {
        boolean oldHasAi = (currentValue & 1) == 0;
        boolean newHasAi = (value & 1) == 0;
        return Optional.of(DataTransactionResult.builder().replace(Value.immutableOf(Keys.IS_AI_ENABLED, Boolean.valueOf(oldHasAi))).success(Value.immutableOf(Keys.IS_AI_ENABLED, Boolean.valueOf(newHasAi))).result(DataTransactionResult.Type.SUCCESS).build());
    }

    @Override
    public Byte getValueFromEvent(Byte originalValue, List<Value.Immutable<?>> immutableValues) {
        for (Value.Immutable<?> immutableValue : immutableValues) {
            if (immutableValue.getKey() != Keys.IS_AI_ENABLED) continue;
            Boolean hasAi = (Boolean)immutableValue.get();
            originalValue = hasAi != false ? (byte)(originalValue & 0xFFFFFFFE) : (byte)(originalValue | 1);
        }
        return originalValue;
    }
}

