/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.key;

import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.data.ChangeDataHolderEvent;
import org.spongepowered.common.AbstractResourceKeyed;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.key.KeyBasedDataListener;
import org.spongepowered.common.data.provider.EmptyDataProvider;
import org.spongepowered.common.data.value.ValueConstructor;
import org.spongepowered.common.data.value.ValueConstructorFactory;
import org.spongepowered.plugin.PluginContainer;

public final class SpongeKey<V extends Value<E>, E>
extends AbstractResourceKeyed
implements Key<V> {
    private final Type valueType;
    private final Type elementType;
    private final Comparator<? super E> elementComparator;
    private final BiPredicate<? super E, ? super E> elementIncludesTester;
    private final ValueConstructor<V, E> valueConstructor;
    private final Supplier<E> defaultValueSupplier;
    private final EmptyDataProvider<V, E> emptyDataProvider;

    public SpongeKey(ResourceKey key, Type valueType, Type elementType, Comparator<? super E> elementComparator, BiPredicate<? super E, ? super E> elementIncludesTester, Supplier<E> defaultValueSupplier) {
        super(key);
        this.valueType = valueType;
        this.elementType = elementType;
        this.elementComparator = elementComparator;
        this.elementIncludesTester = elementIncludesTester;
        this.defaultValueSupplier = defaultValueSupplier;
        this.emptyDataProvider = new EmptyDataProvider(this);
        this.valueConstructor = ValueConstructorFactory.getConstructor(this);
    }

    @Override
    public Type getValueType() {
        return this.valueType;
    }

    @Override
    public Type getElementType() {
        return this.elementType;
    }

    @Override
    public Comparator<? super E> getElementComparator() {
        return this.elementComparator;
    }

    @Override
    public BiPredicate<? super E, ? super E> getElementIncludesTester() {
        return this.elementIncludesTester;
    }

    @Override
    public <H extends DataHolder> void registerEvent(PluginContainer plugin, Class<H> holderFilter, EventListener<ChangeDataHolderEvent.ValueChange> listener) {
        ((SpongeDataManager)Sponge.getGame().getDataManager()).registerKeyListener(new KeyBasedDataListener<H>(plugin, holderFilter, this, listener));
    }

    public ValueConstructor<V, E> getValueConstructor() {
        return this.valueConstructor;
    }

    public Supplier<E> getDefaultValueSupplier() {
        return this.defaultValueSupplier;
    }

    public EmptyDataProvider<V, E> getEmptyDataProvider() {
        return this.emptyDataProvider;
    }
}

