/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.key;

import com.google.common.base.Preconditions;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeFactory;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.ListValue;
import org.spongepowered.api.data.value.SetValue;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.data.value.WeightedCollectionValue;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.common.data.key.SpongeKey;
import org.spongepowered.common.registry.provider.KeyProvider;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;

public final class SpongeKeyBuilder<E, V extends Value<E>>
extends AbstractResourceKeyedBuilder<Key<V>, Key.Builder<E, V>>
implements Key.Builder<E, V> {
    private @Nullable Type valueType;
    private @Nullable Type elementType;
    private @Nullable Comparator<? super E> comparator;
    private @Nullable BiPredicate<? super E, ? super E> includesTester;

    @Override
    public <T, B extends Value<T>> SpongeKeyBuilder<T, B> type(TypeToken<B> token) {
        Objects.requireNonNull(token);
        this.valueType = token.getType();
        Type valueTypeAsSuper = GenericTypeReflector.getExactSuperType(this.valueType, Value.class);
        if (!(valueTypeAsSuper instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Raw type " + this.valueType + " provided when registering Key " + this.key);
        }
        this.elementType = ((ParameterizedType)valueTypeAsSuper).getActualTypeArguments()[0];
        return this;
    }

    @Override
    public <T> Key.Builder<T, Value<T>> elementType(Class<T> type) {
        Objects.requireNonNull(type, "type");
        this.valueType = TypeFactory.parameterizedClass(Value.class, type);
        this.elementType = type;
        return this;
    }

    @Override
    public SpongeKeyBuilder<E, V> comparator(Comparator<? super E> comparator) {
        Preconditions.checkNotNull(comparator);
        this.comparator = comparator;
        return this;
    }

    @Override
    public SpongeKeyBuilder<E, V> includesTester(BiPredicate<? super E, ? super E> predicate) {
        Preconditions.checkNotNull(predicate);
        this.includesTester = predicate;
        return this;
    }

    @Override
    public Key<V> build0() {
        Comparator<Object> comparator;
        Objects.requireNonNull(this.valueType, "The value type must be set");
        Objects.requireNonNull(this.elementType, "The element type must be set");
        BiPredicate<Object, Object> includesTester = this.includesTester;
        if (includesTester == null) {
            includesTester = (e, e2) -> false;
        }
        if ((comparator = this.comparator) == null) {
            comparator = Comparable.class.isAssignableFrom(GenericTypeReflector.erase(this.elementType)) ? Comparator.comparing(o -> (Comparable)o) : (o1, o2) -> {
                if (o1.equals(o2)) {
                    return 0;
                }
                if (o1.hashCode() > o2.hashCode()) {
                    return 1;
                }
                return -1;
            };
        }
        Supplier<Object> defaultValueSupplier = () -> null;
        Class<?> rawType = GenericTypeReflector.erase(this.valueType);
        if (ListValue.class.isAssignableFrom(rawType)) {
            defaultValueSupplier = () -> new ArrayList();
        } else if (SetValue.class.isAssignableFrom(rawType)) {
            defaultValueSupplier = () -> new HashSet();
        } else if (WeightedCollectionValue.class.isAssignableFrom(rawType)) {
            defaultValueSupplier = () -> new WeightedTable();
        }
        SpongeKey key = new SpongeKey(this.key, this.valueType, this.elementType, comparator, includesTester, defaultValueSupplier);
        KeyProvider.INSTANCE.register(this.key, key);
        return key;
    }

    @Override
    public Key.Builder<E, V> reset() {
        this.valueType = null;
        this.includesTester = null;
        this.comparator = null;
        return this;
    }
}

