/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.util.CopyHelper;

abstract class SpongeDataManipulator
implements DataManipulator {
    protected final Map<Key<?>, Object> values;

    SpongeDataManipulator(Map<Key<?>, Object> values) {
        this.values = values;
    }

    Map<Key<?>, Object> copyMap() {
        HashMap copy = new HashMap();
        for (Map.Entry<Key<?>, Object> entry : this.values.entrySet()) {
            copy.put(entry.getKey(), CopyHelper.copy(entry.getValue()));
        }
        return copy;
    }

    @Override
    public <E> Optional<E> get(Key<? extends Value<E>> key) {
        Preconditions.checkNotNull(key, (Object)"key");
        return Optional.ofNullable(CopyHelper.copy(this.values.get(key)));
    }

    @Override
    public <E, V extends Value<E>> Optional<V> getValue(Key<V> key) {
        Preconditions.checkNotNull(key, (Object)"key");
        Object element = CopyHelper.copy(this.values.get(key));
        return element == null ? Optional.empty() : Optional.of(Value.genericMutableOf(key, element));
    }

    @Override
    public boolean supports(Key<?> key) {
        return true;
    }

    @Override
    public Set<Value.Immutable<?>> getValues() {
        return (Set)this.values.entrySet().stream().map(entry -> Value.immutableOf((Key)entry.getKey(), CopyHelper.copy(entry.getValue())).asImmutable()).collect(ImmutableSet.toImmutableSet());
    }

    public String toString() {
        MoreObjects.ToStringHelper builder = MoreObjects.toStringHelper((Object)this);
        for (Map.Entry<Key<?>, Object> entry : this.values.entrySet()) {
            builder.add(entry.getKey().getKey().toString(), entry.getValue());
        }
        return builder.toString();
    }
}

