/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.provider.item.stack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.common.data.provider.DataProviderRegistrator;
import org.spongepowered.common.item.enchantment.SpongeEnchantment;
import org.spongepowered.common.util.NBTCollectors;
import org.spongepowered.common.util.NBTStreams;
import org.spongepowered.common.util.Predicates;

public final class BookPagesItemStackData {
    private static final String NBTKeyAppliedEnchantments = "Enchantments";
    private static final String NBTKeyStoredEnchantments = "StoredEnchantments";

    private BookPagesItemStackData() {
    }

    public static void register(DataProviderRegistrator registrator) {
        ((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)((DataProviderRegistrator.MutableRegistration)registrator.asMutable(ItemStack.class).create(Keys.APPLIED_ENCHANTMENTS).get(h2 -> BookPagesItemStackData.get(h2, NBTKeyAppliedEnchantments))).set((h2, v) -> BookPagesItemStackData.set(h2, v, iv -> iv.stream().filter(Predicates.distinctBy(org.spongepowered.api.item.enchantment.Enchantment::getType)), NBTKeyAppliedEnchantments))).delete(h2 -> BookPagesItemStackData.delete(h2, NBTKeyAppliedEnchantments))).create(Keys.STORED_ENCHANTMENTS).get(h2 -> BookPagesItemStackData.get(h2, NBTKeyStoredEnchantments))).set((h2, v) -> BookPagesItemStackData.set(h2, v, Collection::stream, NBTKeyStoredEnchantments))).delete(h2 -> BookPagesItemStackData.delete(h2, NBTKeyStoredEnchantments))).supports(h2 -> h2.func_77973_b() == Items.field_151134_bR);
    }

    private static List<org.spongepowered.api.item.enchantment.Enchantment> get(ItemStack holder, String nbtKey) {
        CompoundNBT tag = holder.func_77978_p();
        if (tag == null || !tag.func_150297_b(nbtKey, 9)) {
            return new ArrayList<org.spongepowered.api.item.enchantment.Enchantment>();
        }
        ListNBT list = tag.func_150295_c(nbtKey, 10);
        return NBTStreams.toCompounds((Iterable<INBT>)list).map(BookPagesItemStackData::enchantmentFromNbt).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static boolean set(ItemStack holder, List<org.spongepowered.api.item.enchantment.Enchantment> value, Function<List<org.spongepowered.api.item.enchantment.Enchantment>, Stream<org.spongepowered.api.item.enchantment.Enchantment>> filter, String nbtKey) {
        if (value.isEmpty()) {
            return BookPagesItemStackData.delete(holder, nbtKey);
        }
        CompoundNBT tag = holder.func_196082_o();
        ListNBT list = filter.apply(value).map(BookPagesItemStackData::enchantmentToNbt).collect(NBTCollectors.toTagList());
        tag.func_218657_a(nbtKey, (INBT)list);
        return true;
    }

    private static boolean delete(ItemStack holder, String nbtKey) {
        CompoundNBT tag = holder.func_77978_p();
        if (tag != null) {
            tag.func_82580_o(nbtKey);
        }
        return true;
    }

    private static org.spongepowered.api.item.enchantment.Enchantment enchantmentFromNbt(CompoundNBT compound) {
        String enchantmentId = compound.func_74779_i("id");
        int level = compound.func_74762_e("lvl");
        EnchantmentType enchantment = Registry.field_212628_q.func_241873_b(ResourceLocation.func_208304_a((String)enchantmentId)).orElse(null);
        return enchantment == null ? null : new SpongeEnchantment(enchantment, level);
    }

    private static CompoundNBT enchantmentToNbt(org.spongepowered.api.item.enchantment.Enchantment enchantment) {
        CompoundNBT compound = new CompoundNBT();
        String enchantmentId = String.valueOf(Registry.field_212628_q.func_177774_c((Object)((Enchantment)enchantment.getType())));
        compound.func_74778_a("id", enchantmentId);
        compound.func_74777_a("lvl", (short)((byte)enchantment.getLevel()));
        return compound;
    }
}

