/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.datapack.recipe;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.spongepowered.common.datapack.DataPackSerializer;
import org.spongepowered.common.datapack.recipe.RecipeSerializedObject;

public final class RecipeDataPackSerializer
extends DataPackSerializer<RecipeSerializedObject> {
    public RecipeDataPackSerializer() {
        super("Recipes", "recipes");
    }

    @Override
    protected void serializeAdditional(Path dataDirectory, RecipeSerializedObject object) throws IOException {
        if (object.getAdvancementObject() != null) {
            Path advancementFile = dataDirectory.resolve("advancements").resolve(object.getAdvancementObject().getKey().getValue() + ".json");
            Files.createDirectories(advancementFile.getParent(), new FileAttribute[0]);
            RecipeDataPackSerializer.writeFile(advancementFile, object.getAdvancementObject().getObject());
        }
    }
}

