/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.ai.goal.builtin.creature.target;

import com.google.common.base.Preconditions;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import org.spongepowered.api.entity.ai.goal.builtin.creature.target.FindNearestAttackableTargetGoal;
import org.spongepowered.api.entity.living.Creature;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.common.entity.ai.goal.builtin.creature.target.SpongeTargetGoalBuilder;

public final class SpongeFindNearestAttackableTargetGoalBuilder
extends SpongeTargetGoalBuilder<FindNearestAttackableTargetGoal, FindNearestAttackableTargetGoal.Builder>
implements FindNearestAttackableTargetGoal.Builder {
    private static final Predicate<LivingEntity> ALWAYS_TRUE = e -> true;
    private Class<? extends Living> targetClass;
    private int chance;
    @Nullable
    private Predicate<? extends LivingEntity> predicate;

    public SpongeFindNearestAttackableTargetGoalBuilder() {
        this.reset();
    }

    @Override
    public FindNearestAttackableTargetGoal.Builder target(Class<? extends Living> targetClass) {
        this.targetClass = targetClass;
        return this;
    }

    @Override
    public FindNearestAttackableTargetGoal.Builder chance(int chance) {
        this.chance = chance;
        return this;
    }

    @Override
    public FindNearestAttackableTargetGoal.Builder filter(Predicate<? extends Living> predicate) {
        this.predicate = predicate;
        return this;
    }

    @Override
    public FindNearestAttackableTargetGoal.Builder from(FindNearestAttackableTargetGoal value) {
        Preconditions.checkNotNull((Object)value);
        this.targetClass = value.getTargetClass();
        this.checkSight = value.shouldCheckSight();
        this.checkOnlyNearby = value.shouldCheckOnlyNearby();
        this.chance = value.getChance();
        this.predicate = value.getFilter();
        return this;
    }

    @Override
    public FindNearestAttackableTargetGoal.Builder reset() {
        this.checkSight = false;
        this.checkOnlyNearby = false;
        this.targetClass = null;
        this.predicate = null;
        return this;
    }

    @Override
    public FindNearestAttackableTargetGoal build(Creature owner) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull(this.targetClass);
        return (FindNearestAttackableTargetGoal)new NearestAttackableTargetGoal((MobEntity)((CreatureEntity)owner), this.targetClass, this.chance, this.checkSight, this.checkOnlyNearby, this.predicate == null ? ALWAYS_TRUE : this.predicate);
    }
}

