/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.projectile;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.item.ExperienceBottleEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.DragonFireballEntity;
import net.minecraft.entity.projectile.EggEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.entity.projectile.LlamaSpitEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.entity.projectile.SpectralArrowEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import org.spongepowered.api.block.entity.carrier.Dispenser;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.golem.Shulker;
import org.spongepowered.api.entity.projectile.Egg;
import org.spongepowered.api.entity.projectile.EnderPearl;
import org.spongepowered.api.entity.projectile.ExperienceBottle;
import org.spongepowered.api.entity.projectile.FishingBobber;
import org.spongepowered.api.entity.projectile.LlamaSpit;
import org.spongepowered.api.entity.projectile.Potion;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.entity.projectile.Snowball;
import org.spongepowered.api.entity.projectile.arrow.Arrow;
import org.spongepowered.api.entity.projectile.arrow.SpectralArrow;
import org.spongepowered.api.entity.projectile.explosive.FireworkRocket;
import org.spongepowered.api.entity.projectile.explosive.WitherSkull;
import org.spongepowered.api.entity.projectile.explosive.fireball.DragonFireball;
import org.spongepowered.api.entity.projectile.explosive.fireball.ExplosiveFireball;
import org.spongepowered.api.entity.projectile.explosive.fireball.SmallFireball;
import org.spongepowered.api.projectile.source.ProjectileSource;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.entity.projectile.DispenserSourceLogic;
import org.spongepowered.common.entity.projectile.ProjectileLogic;
import org.spongepowered.common.entity.projectile.ProjectileSourceLogic;
import org.spongepowered.common.entity.projectile.ShulkerSourceLogic;
import org.spongepowered.common.entity.projectile.SimpleDispenserLaunchLogic;
import org.spongepowered.common.entity.projectile.SimpleEntityLaunchLogic;
import org.spongepowered.common.entity.projectile.SimpleItemLaunchLogic;

public final class ProjectileUtil {
    private static final Map<EntityType<? extends Projectile>, ProjectileLogic<?>> projectileLogic = Maps.newHashMap();
    private static final Map<Class<? extends ProjectileSource>, ProjectileSourceLogic<?>> projectileSourceLogic = Maps.newHashMap();

    public static <T extends Projectile> Optional<T> launch(EntityType<T> projectileType, ProjectileSource source, @Nullable org.spongepowered.math.vector.Vector3d vel) {
        ProjectileLogic<T> logic = ProjectileUtil.getLogic(projectileType);
        if (logic == null) {
            return Optional.empty();
        }
        Optional<Projectile> projectile = logic.launch(source);
        projectile.ifPresent(t -> {
            if (vel != null) {
                t.offer(Keys.VELOCITY, vel);
            }
            t.offer(Keys.SHOOTER, source);
        });
        return projectile;
    }

    public static <T extends Projectile, S extends ProjectileSource> Optional<T> launchWithArgs(EntityType<T> projectileType, Class<S> projectileSourceClass, S source, @Nullable org.spongepowered.math.vector.Vector3d vel, Object ... args) {
        ProjectileSourceLogic<S> sourceLogic = ProjectileUtil.getSourceLogic(projectileSourceClass);
        if (sourceLogic == null) {
            return Optional.empty();
        }
        ProjectileLogic<T> logic = ProjectileUtil.getLogic(projectileType);
        if (logic == null) {
            return Optional.empty();
        }
        Optional<Projectile> projectile = sourceLogic.launch(logic, source, projectileType, args);
        projectile.ifPresent(t -> {
            if (vel != null) {
                t.offer(Keys.VELOCITY, vel);
            }
            t.offer(Keys.SHOOTER, source);
        });
        return projectile;
    }

    private static void configureThrowable(ThrowableEntity entity) {
        double x = entity.func_226277_ct_() - (double)(MathHelper.func_76134_b((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        double y = entity.func_226278_cu_() - 0.1;
        double z = entity.func_226281_cx_() - (double)(MathHelper.func_76126_a((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        entity.func_70107_b(x, y, z);
        float f = 0.4f;
        double motionX = -MathHelper.func_76126_a((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(entity.field_70125_A / 180.0f * (float)Math.PI)) * 0.4f;
        double motionZ = MathHelper.func_76134_b((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(entity.field_70125_A / 180.0f * (float)Math.PI)) * 0.4f;
        double motionY = -MathHelper.func_76126_a((float)(entity.field_70125_A / 180.0f * (float)Math.PI)) * 0.4f;
        entity.func_213293_j(motionX, motionY, motionZ);
    }

    public static <T extends Projectile> void registerProjectileLogic(Supplier<EntityType<T>> projectileType, ProjectileLogic<T> logic) {
        projectileLogic.put(projectileType.get(), logic);
    }

    public static <T extends ProjectileSource> void registerProjectileSourceLogic(Class<T> projectileSourceClass, ProjectileSourceLogic<T> logic) {
        projectileSourceLogic.put(projectileSourceClass, logic);
    }

    static <T extends ProjectileSource> ProjectileSourceLogic<T> getSourceLogic(Class<T> sourceClass) {
        return projectileSourceLogic.get(sourceClass);
    }

    private static <T extends Projectile> ProjectileLogic<T> getLogic(EntityType<T> projectileType) {
        return projectileLogic.get(projectileType);
    }

    static <P extends Projectile> Optional<P> defaultLaunch(ProjectileSource source, EntityType<P> projectileType, ServerLocation loc) {
        Entity projectile = ((ServerWorld)loc.getWorld()).createEntity(projectileType, loc.getPosition());
        if (projectile instanceof ThrowableEntity) {
            ProjectileUtil.configureThrowable((ThrowableEntity)projectile);
        }
        return ProjectileUtil.doLaunch(loc.getWorld(), (Projectile)projectile);
    }

    static <P extends Projectile> Optional<P> doLaunch(World extent, P projectile) {
        if (extent.spawnEntity(projectile)) {
            return Optional.of(projectile);
        }
        return Optional.empty();
    }

    static {
        ProjectileUtil.registerProjectileSourceLogic(Dispenser.class, new DispenserSourceLogic());
        ProjectileUtil.registerProjectileSourceLogic(Shulker.class, new ShulkerSourceLogic());
        ProjectileUtil.registerProjectileLogic(EntityTypes.ARROW, new SimpleItemLaunchLogic<Arrow>(EntityTypes.ARROW, Items.field_151032_g){

            @Override
            protected Optional<Arrow> createProjectile(LivingEntity source, ServerLocation loc) {
                ArrowEntity arrow = new ArrowEntity(source.field_70170_p, source);
                arrow.func_70186_c((double)source.field_70125_A, (double)source.field_70177_z, 0.0, 3.0f, 0.0f);
                return ProjectileUtil.doLaunch(loc.getWorld(), (Arrow)arrow);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.SPECTRAL_ARROW, new SimpleItemLaunchLogic<SpectralArrow>(EntityTypes.SPECTRAL_ARROW, Items.field_185166_h){

            @Override
            protected Optional<SpectralArrow> createProjectile(LivingEntity source, ServerLocation loc) {
                SpectralArrowEntity arrow = new SpectralArrowEntity(source.field_70170_p, source);
                arrow.func_70186_c((double)source.field_70125_A, (double)source.field_70177_z, 0.0, 3.0f, 0.0f);
                return ProjectileUtil.doLaunch(loc.getWorld(), (SpectralArrow)arrow);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.EGG, new SimpleItemLaunchLogic<Egg>(EntityTypes.EGG, Items.field_151110_aK){

            @Override
            protected Optional<Egg> createProjectile(LivingEntity source, ServerLocation loc) {
                EggEntity egg = new EggEntity(source.field_70170_p, source);
                egg.func_70186_c((double)source.field_70125_A, (double)source.field_70177_z, 0.0, 1.5f, 0.0f);
                return ProjectileUtil.doLaunch(loc.getWorld(), (Egg)egg);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.SMALL_FIREBALL, new SimpleItemLaunchLogic<SmallFireball>(EntityTypes.SMALL_FIREBALL, Items.field_151059_bz){

            @Override
            protected Optional<SmallFireball> createProjectile(LivingEntity source, ServerLocation loc) {
                Vector3d lookVec = source.func_70676_i(1.0f);
                SmallFireballEntity fireball = new SmallFireballEntity(source.field_70170_p, source, lookVec.field_72450_a * 4.0, lookVec.field_72448_b * 4.0, lookVec.field_72449_c * 4.0);
                fireball.func_70107_b(fireball.func_226277_ct_(), fireball.func_226278_cu_() + (double)source.func_70047_e(), fireball.func_226281_cx_());
                return ProjectileUtil.doLaunch(loc.getWorld(), (SmallFireball)fireball);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.FIREWORK_ROCKET, new SimpleItemLaunchLogic<FireworkRocket>(EntityTypes.FIREWORK_ROCKET, Items.field_196152_dE){

            @Override
            protected Optional<FireworkRocket> createProjectile(LivingEntity source, ServerLocation loc) {
                FireworkRocketEntity firework = new FireworkRocketEntity(source.field_70170_p, loc.getX(), loc.getY(), loc.getZ(), ItemStack.field_190927_a);
                return ProjectileUtil.doLaunch(loc.getWorld(), (FireworkRocket)firework);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.SNOWBALL, new SimpleItemLaunchLogic<Snowball>(EntityTypes.SNOWBALL, Items.field_151126_ay){

            @Override
            protected Optional<Snowball> createProjectile(LivingEntity source, ServerLocation loc) {
                SnowballEntity snowball = new SnowballEntity(source.field_70170_p, source);
                snowball.func_70186_c((double)source.field_70125_A, (double)source.field_70177_z, 0.0, 1.5f, 0.0f);
                return ProjectileUtil.doLaunch(loc.getWorld(), (Snowball)snowball);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.EXPERIENCE_BOTTLE, new SimpleItemLaunchLogic<ExperienceBottle>(EntityTypes.EXPERIENCE_BOTTLE, Items.field_151062_by){

            @Override
            protected Optional<ExperienceBottle> createProjectile(LivingEntity source, ServerLocation loc) {
                ExperienceBottleEntity expBottle = new ExperienceBottleEntity(source.field_70170_p, source);
                expBottle.func_70186_c((double)source.field_70125_A, (double)source.field_70177_z, -20.0, 0.7f, 0.0f);
                return ProjectileUtil.doLaunch(loc.getWorld(), (ExperienceBottle)expBottle);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.ENDER_PEARL, new SimpleItemLaunchLogic<EnderPearl>(EntityTypes.ENDER_PEARL, Items.field_151079_bi){

            @Override
            protected Optional<EnderPearl> createProjectile(LivingEntity source, ServerLocation loc) {
                EnderPearlEntity pearl = new EnderPearlEntity(source.field_70170_p, source);
                pearl.func_70186_c((double)source.field_70125_A, (double)source.field_70177_z, 0.0, 1.5f, 0.0f);
                return ProjectileUtil.doLaunch(loc.getWorld(), (EnderPearl)pearl);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.FIREBALL, new SimpleDispenserLaunchLogic<ExplosiveFireball>(EntityTypes.FIREBALL){

            @Override
            protected Optional<ExplosiveFireball> createProjectile(LivingEntity source, ServerLocation loc) {
                Vector3d lookVec = source.func_70676_i(1.0f);
                FireballEntity fireball = new FireballEntity(source.field_70170_p, source, lookVec.field_72450_a * 4.0, lookVec.field_72448_b * 4.0, lookVec.field_72449_c * 4.0);
                fireball.func_70107_b(fireball.func_226277_ct_(), fireball.func_226278_cu_() + (double)source.func_70047_e(), fireball.func_226281_cx_());
                return ProjectileUtil.doLaunch(loc.getWorld(), (ExplosiveFireball)fireball);
            }

            @Override
            public Optional<ExplosiveFireball> createProjectile(ProjectileSource source, EntityType<ExplosiveFireball> projectileType, ServerLocation loc) {
                if (!(source instanceof DispenserTileEntity)) {
                    return super.createProjectile(source, projectileType, loc);
                }
                DispenserTileEntity dispenser = (DispenserTileEntity)source;
                Direction enumfacing = DispenserSourceLogic.getFacing(dispenser);
                ArmorStandEntity thrower = new ArmorStandEntity(dispenser.func_145831_w(), loc.getX() + (double)enumfacing.func_82601_c(), loc.getY() + (double)enumfacing.func_96559_d(), loc.getZ() + (double)enumfacing.func_82599_e());
                FireballEntity fireball = new FireballEntity(dispenser.func_145831_w(), (LivingEntity)thrower, 0.0, 0.0, 0.0);
                fireball.field_70232_b = (double)enumfacing.func_82601_c() * 0.1;
                fireball.field_70233_c = (double)enumfacing.func_96559_d() * 0.1;
                fireball.field_70230_d = (double)enumfacing.func_82599_e() * 0.1;
                return ProjectileUtil.doLaunch(loc.getWorld(), (ExplosiveFireball)fireball);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.WITHER_SKULL, new SimpleDispenserLaunchLogic<WitherSkull>(EntityTypes.WITHER_SKULL){

            @Override
            protected Optional<WitherSkull> createProjectile(LivingEntity source, ServerLocation loc) {
                Vector3d lookVec = source.func_70676_i(1.0f);
                WitherSkullEntity skull = new WitherSkullEntity(source.field_70170_p, source, lookVec.field_72450_a * 4.0, lookVec.field_72448_b * 4.0, lookVec.field_72449_c * 4.0);
                skull.func_70107_b(skull.func_226277_ct_(), skull.func_226278_cu_() + (double)source.func_70047_e(), skull.func_226281_cx_());
                return ProjectileUtil.doLaunch(loc.getWorld(), (WitherSkull)skull);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.EYE_OF_ENDER, new SimpleDispenserLaunchLogic(EntityTypes.EYE_OF_ENDER));
        ProjectileUtil.registerProjectileLogic(EntityTypes.FISHING_BOBBER, new SimpleDispenserLaunchLogic<FishingBobber>(EntityTypes.FISHING_BOBBER){

            @Override
            protected Optional<FishingBobber> createProjectile(LivingEntity source, ServerLocation loc) {
                if (source instanceof PlayerEntity) {
                    FishingBobberEntity hook = new FishingBobberEntity(source.field_70170_p, (PlayerEntity)source, loc.getX(), loc.getY(), loc.getZ());
                    return ProjectileUtil.doLaunch(loc.getWorld(), (FishingBobber)hook);
                }
                return super.createProjectile(source, loc);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.POTION, new SimpleItemLaunchLogic<Potion>(EntityTypes.POTION, Items.field_185155_bH){

            @Override
            protected Optional<Potion> createProjectile(LivingEntity source, ServerLocation loc) {
                PotionEntity potion = new PotionEntity(source.field_70170_p, source);
                potion.func_213884_b(new ItemStack((IItemProvider)Items.field_185155_bH, 1));
                potion.func_70186_c((double)source.field_70125_A, (double)source.field_70177_z, -20.0, 0.5f, 0.0f);
                return ProjectileUtil.doLaunch(loc.getWorld(), (Potion)potion);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.LLAMA_SPIT, new SimpleEntityLaunchLogic<LlamaSpit>(EntityTypes.LLAMA_SPIT){

            @Override
            public Optional<LlamaSpit> launch(ProjectileSource source) {
                if (!(source instanceof LlamaEntity)) {
                    return Optional.empty();
                }
                return super.launch(source);
            }

            @Override
            public Optional<LlamaSpit> createProjectile(ProjectileSource source, EntityType<LlamaSpit> projectileType, ServerLocation loc) {
                LlamaEntity llama = (LlamaEntity)source;
                LlamaSpitEntity llamaSpit = new LlamaSpitEntity(llama.field_70170_p, (LlamaEntity)source);
                Vector3d lookVec = llama.func_70676_i(1.0f);
                llamaSpit.func_70186_c(lookVec.field_72450_a, lookVec.field_72448_b, lookVec.field_72449_c, 1.5f, 0.0f);
                return ProjectileUtil.doLaunch(loc.getWorld(), (LlamaSpit)llamaSpit);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.DRAGON_FIREBALL, new SimpleDispenserLaunchLogic<DragonFireball>(EntityTypes.DRAGON_FIREBALL){

            @Override
            protected Optional<DragonFireball> createProjectile(LivingEntity source, ServerLocation loc) {
                Vector3d lookVec = source.func_70676_i(1.0f);
                DragonFireballEntity fireball = new DragonFireballEntity(source.field_70170_p, source, lookVec.field_72450_a * 4.0, lookVec.field_72448_b * 4.0, lookVec.field_72449_c * 4.0);
                fireball.func_70107_b(fireball.func_226277_ct_(), fireball.func_226278_cu_() + (double)source.func_70047_e(), fireball.func_226281_cx_());
                return ProjectileUtil.doLaunch(loc.getWorld(), (DragonFireball)fireball);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.SHULKER_BULLET, new SimpleEntityLaunchLogic(EntityTypes.SHULKER_BULLET));
    }
}

